/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.player.PlayerInteractEvent;

public class Ammeter
extends AbstractMechanic {
    protected MechanismsPlugin plugin;

    public Ammeter(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.wrap(event.getPlayer()).hasPermission("craftbook.mech.ammeter.use")) {
            return;
        }
        Block block = event.getClickedBlock();
        if (event.getPlayer().getItemInHand().getType() == Material.COAL && (BlockType.canTransferRedstone((int)block.getTypeId()) || BlockType.isRedstoneSource((int)block.getTypeId()))) {
            int data = this.getSpecialData(block);
            String line = this.getCurrentLine(data);
            int current = data;
            event.getPlayer().sendMessage(ChatColor.YELLOW + "Ammeter: " + line + ChatColor.WHITE + " " + current + " A");
        }
    }

    private int getSpecialData(Block block) {
        Material type = block.getType();
        byte data = block.getData();
        int current = 0;
        if (type == Material.LEVER || type == Material.STONE_BUTTON) {
            if ((data & 8) == 8) {
                current = 15;
            }
        } else if (type == Material.STONE_PLATE || type == Material.STONE_PLATE) {
            if ((data & 1) == 1) {
                current = 15;
            }
        } else if (type == Material.POWERED_RAIL || type == Material.DETECTOR_RAIL) {
            if (data >= 8) {
                current = 15;
            }
        } else if (type == Material.REDSTONE_TORCH_ON) {
            current = 15;
        } else if (type == Material.REDSTONE_TORCH_OFF) {
            current = 0;
        } else if (type == Material.REDSTONE_WIRE) {
            current = data;
        }
        return current;
    }

    private String getCurrentLine(int data) {
        int i;
        String line = ChatColor.YELLOW + "[";
        if (data > 10) {
            line = line + ChatColor.DARK_GREEN;
        } else if (data > 5) {
            line = line + ChatColor.GOLD;
        } else if (data > 0) {
            line = line + ChatColor.DARK_RED;
        }
        for (i = 0; i < data; ++i) {
            line = line + "|";
        }
        line = line + ChatColor.BLACK;
        for (i = data; i < 15; ++i) {
            line = line + "|";
        }
        line = line + ChatColor.YELLOW + "]";
        return line;
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Ammeter> {
        protected MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public Ammeter detect(BlockWorldVector pt) {
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (BlockType.canTransferRedstone((int)block.getTypeId()) || BlockType.isRedstoneSource((int)block.getTypeId())) {
                return new Ammeter(this.plugin);
            }
            return null;
        }
    }
}

