/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;

public class Bookcase
extends AbstractMechanic {
    protected static Random rand = new Random();
    protected MechanismsPlugin plugin;

    public Bookcase(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public void read(LocalPlayer player, String bookReadLine) {
        if (!player.hasPermission("craftbook.mech.bookshelf.use")) {
            return;
        }
        try {
            String text = this.getBookLine();
            if (text != null) {
                player.print(bookReadLine);
                player.printRaw(text);
            } else {
                player.printError("Failed to fetch a line from the books file.");
            }
        }
        catch (IOException e) {
            player.printError("Failed to read the books file.");
        }
    }

    protected String getBookLine() throws IOException {
        RandomAccessFile file = new RandomAccessFile(new File(this.plugin.getLocalConfiguration().dataFolder, "books.txt"), "r");
        long len = file.length();
        byte[] data = new byte[500];
        for (int tries = 0; tries < 3; ++tries) {
            int j = rand.nextInt((int)len);
            if (tries == 2) {
                j = 0;
            }
            file.seek(j);
            file.read(data);
            StringBuilder buffer = new StringBuilder();
            boolean found = j == 0;
            int last = 0;
            for (int i = 0; i < data.length; ++i) {
                if (found) {
                    if (data[i] == 10 || data[i] == 13 || (long)i >= len) {
                        if (last != 10 && last != 13) {
                            file.close();
                            return buffer.toString();
                        }
                    } else {
                        buffer.appendCodePoint(data[i]);
                    }
                } else if (data[i] == 10 || data[i] == 13) {
                    found = true;
                }
                last = data[i];
            }
        }
        file.close();
        return null;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().bookcaseSettings.enable) {
            return;
        }
        Player player = event.getPlayer();
        this.read(this.plugin.wrap(player), this.plugin.getLocalConfiguration().bookcaseSettings.readLine);
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Bookcase> {
        protected MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public Bookcase detect(BlockWorldVector pt) {
            if (pt.getWorld().getBlockType((Vector)pt) == 47) {
                return new Bookcase(pt, this.plugin);
            }
            return null;
        }
    }
}

