/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;

public class HiddenSwitch
extends AbstractMechanic {
    Block switchBlock;
    MechanismsPlugin plugin;

    public HiddenSwitch(Block block, MechanismsPlugin plugin) {
        this.switchBlock = block;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        Sign s;
        if (event.getBlockFace() != BlockFace.EAST && event.getBlockFace() != BlockFace.WEST && event.getBlockFace() != BlockFace.NORTH && event.getBlockFace() != BlockFace.SOUTH) {
            return;
        }
        Block testBlock = this.switchBlock.getRelative(event.getBlockFace().getOppositeFace());
        if (testBlock.getType() == Material.WALL_SIGN && (s = (Sign)testBlock.getState()).getLine(1).equalsIgnoreCase("[x]")) {
            this.toggleSwitches(testBlock, event.getBlockFace().getOppositeFace());
        }
    }

    private void toggleSwitches(Block sign, BlockFace direction) {
        Block adj2;
        Block adj1;
        Block up = sign.getRelative(BlockFace.UP);
        Block down = sign.getRelative(BlockFace.DOWN);
        if (direction == BlockFace.EAST || direction == BlockFace.WEST) {
            adj1 = sign.getRelative(BlockFace.NORTH);
            adj2 = sign.getRelative(BlockFace.SOUTH);
        } else {
            adj1 = sign.getRelative(BlockFace.EAST);
            adj2 = sign.getRelative(BlockFace.WEST);
        }
        if (up != null && up.getType() == Material.LEVER) {
            up.setData((byte)(up.getData() ^ 8));
        }
        if (down != null && down.getType() == Material.LEVER) {
            down.setData((byte)(down.getData() ^ 8));
        }
        if (adj1 != null && adj1.getType() == Material.LEVER) {
            adj1.setData((byte)(adj1.getData() ^ 8));
        }
        if (adj2 != null && adj2.getType() == Material.LEVER) {
            adj2.setData((byte)(adj2.getData() ^ 8));
        }
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<HiddenSwitch> {
        MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public HiddenSwitch detect(BlockWorldVector pos) throws InvalidMechanismException {
            int myBlock = BukkitUtil.toWorld((WorldVector)pos).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pos));
            World wrd = BukkitUtil.toWorld((WorldVector)pos);
            if (this.isValidWallsign(wrd, pos.add(1, 0, 0)) || this.isValidWallsign(wrd, pos.add(-1, 0, 0)) || this.isValidWallsign(wrd, pos.add(0, 0, 1)) || this.isValidWallsign(wrd, pos.add(0, 0, -1))) {
                return new HiddenSwitch(BukkitUtil.toBlock((BlockWorldVector)pos), this.plugin);
            }
            return null;
        }

        private boolean isValidWallsign(World world, Vector pos) {
            Block b = world.getBlockAt((int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
            if (b.getType() != Material.WALL_SIGN) {
                return false;
            }
            Sign s = (Sign)b.getState();
            return s.getLine(1).equalsIgnoreCase("[x]");
        }
    }
}

