/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;

public class LightSwitch
extends AbstractMechanic {
    private HistoryHashMap<BlockWorldVector, Long> recentLightToggles = new HistoryHashMap(20);
    protected MechanismsPlugin plugin;
    private BlockWorldVector pt;

    private LightSwitch(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.pt = pt;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().lightSwitchSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)this.pt)) {
            return;
        }
        this.toggleLights(this.pt);
    }

    private boolean toggleLights(BlockWorldVector pt) {
        int wz;
        int wy;
        int wx;
        World world = BukkitUtil.toWorld((WorldVector)pt);
        int aboveID = world.getBlockTypeIdAt(wx = pt.getBlockX(), (wy = pt.getBlockY()) + 1, wz = pt.getBlockZ());
        if (aboveID == 50 || aboveID == 75 || aboveID == 76) {
            boolean on = aboveID != 50;
            Long lastUse = (Long)this.recentLightToggles.remove(pt);
            long currTime = System.currentTimeMillis();
            if (lastUse != null && currTime - lastUse < 500L) {
                this.recentLightToggles.put(pt, lastUse);
                return true;
            }
            this.recentLightToggles.put(pt, currTime);
            int changed = 0;
            for (int x = -10 + wx; x <= 10 + wx; ++x) {
                for (int y = -10 + wy; y <= 10 + wy; ++y) {
                    for (int z = -5 + wz; z <= 5 + wz; ++z) {
                        int id = world.getBlockTypeIdAt(x, y, z);
                        if (id != 50 && id != 75 && id != 76) continue;
                        if (changed >= 20) {
                            return true;
                        }
                        if (on) {
                            world.getBlockAt(x, y, z).setTypeId(50);
                        } else {
                            world.getBlockAt(x, y, z).setTypeId(76);
                        }
                        ++changed;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<LightSwitch> {
        protected MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public LightSwitch detect(BlockWorldVector pt) {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() != 68) {
                return null;
            }
            String line = ((Sign)block.getState()).getLine(1);
            if (!line.equalsIgnoreCase("[|]") && !line.equalsIgnoreCase("[I]")) {
                return null;
            }
            return new LightSwitch(pt, this.plugin);
        }

        @Override
        public LightSwitch detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            String line = sign.getLine(1);
            if (line.equalsIgnoreCase("[|]") || line.equalsIgnoreCase("[I]")) {
                if (!player.hasPermission("craftbook.mech.light-switch")) {
                    throw new InsufficientPermissionsException();
                }
            } else {
                return null;
            }
            sign.setLine(1, "[I]");
            player.print("Light switch created.");
            throw new ProcessedMechanismException();
        }
    }
}

