/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@ComponentInformation(friendlyName="Debug", desc="Provides useful debugging information for server owners.")
public class DebugComponent
extends BukkitComponent {
    public void enable() {
        this.registerCommands(Commands.class);
    }

    public class DebugCommands {
        @Command(aliases={"clock"}, usage="", desc="Tests the clock rate of your server", flags="", min=0, max=1)
        @CommandPermissions(value={"commandbook.debug.clock"})
        public void testClock(CommandContext args, final CommandSender sender) throws CommandException {
            int expected = 5;
            if (args.argsLength() == 1) {
                expected = Math.min(30, Math.max(1, args.getInteger(0)));
            }
            sender.sendMessage(ChatColor.DARK_RED + "Timing clock test for " + expected + " IN-GAME seconds...");
            sender.sendMessage(ChatColor.DARK_RED + "DO NOT CHANGE A WORLD'S TIME OR PERFORM A HEAVY OPERATION.");
            final World world = (World)CommandBook.server().getWorlds().get(0);
            final double expectedTime = expected * 1000;
            final double expectedSecs = expected;
            final int expectedTicks = 20 * (int)expectedSecs;
            final long start = System.currentTimeMillis();
            final long startTicks = world.getFullTime();
            Runnable task = new Runnable(){

                public void run() {
                    long now = System.currentTimeMillis();
                    long nowTicks = world.getFullTime();
                    long elapsedTime = now - start;
                    double elapsedSecs = (double)elapsedTime / 1000.0;
                    int elapsedTicks = (int)(nowTicks - startTicks);
                    double error = (expectedTime - (double)elapsedTime) / (double)elapsedTime * 100.0;
                    double clockRate = (double)elapsedTicks / elapsedSecs;
                    if (expectedTicks != elapsedTicks) {
                        sender.sendMessage(ChatColor.DARK_RED + "Warning: Bukkit scheduler inaccurate; expected " + expectedTicks + ", got " + elapsedTicks);
                    }
                    if (Math.round(clockRate) == 20L) {
                        sender.sendMessage(ChatColor.YELLOW + "Clock test result: " + ChatColor.GREEN + "EXCELLENT");
                    } else if (elapsedSecs > expectedSecs) {
                        if (clockRate < 19.0) {
                            sender.sendMessage(ChatColor.YELLOW + "Clock test result: " + ChatColor.DARK_RED + "CLOCK BEHIND");
                            sender.sendMessage(ChatColor.DARK_RED + "WARNING: You have potential block respawn issues.");
                        } else {
                            sender.sendMessage(ChatColor.YELLOW + "Clock test result: " + ChatColor.DARK_RED + "CLOCK BEHIND");
                        }
                    } else {
                        sender.sendMessage(ChatColor.YELLOW + "Clock test result: " + ChatColor.DARK_RED + "CLOCK AHEAD");
                    }
                    sender.sendMessage(ChatColor.GRAY + "Expected time elapsed: " + expectedTime + "ms");
                    sender.sendMessage(ChatColor.GRAY + "Time elapsed: " + elapsedTime + "ms");
                    sender.sendMessage(ChatColor.GRAY + "Error: " + error + "%");
                    sender.sendMessage(ChatColor.GRAY + "Actual clock rate: " + clockRate + " ticks/sec");
                    sender.sendMessage(ChatColor.GRAY + "Expected clock rate: 20 ticks/sec");
                }
            };
            CommandBook.server().getScheduler().scheduleSyncDelayedTask((Plugin)CommandBook.inst(), task, (long)expectedTicks);
        }

        @Command(aliases={"info"}, usage="", desc="Get server information", flags="", min=0, max=0)
        @CommandPermissions(value={"commandbook.debug.info"})
        public void serverInfo(CommandContext args, CommandSender sender) throws CommandException {
            Runtime rt = Runtime.getRuntime();
            sender.sendMessage(ChatColor.YELLOW + String.format("System: %s %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
            sender.sendMessage(ChatColor.YELLOW + String.format("Java: %s %s (%s)", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("java.vendor.url")));
            sender.sendMessage(ChatColor.YELLOW + String.format("JVM: %s %s %s", System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version")));
            sender.sendMessage(ChatColor.YELLOW + "Available processors: " + rt.availableProcessors());
            sender.sendMessage(ChatColor.YELLOW + "Available total memory: " + Math.floor((double)rt.maxMemory() / 1024.0 / 1024.0) + " MB");
            sender.sendMessage(ChatColor.YELLOW + "JVM allocated memory: " + Math.floor((double)rt.totalMemory() / 1024.0 / 1024.0) + " MB");
            sender.sendMessage(ChatColor.YELLOW + "Free allocated memory: " + Math.floor((double)rt.freeMemory() / 1024.0 / 1024.0) + " MB");
        }
    }

    public class Commands {
        @Command(aliases={"debug"}, desc="Debugging commands")
        @NestedCommand(value={DebugCommands.class})
        public void debug(CommandContext args, CommandSender sender) throws CommandException {
        }
    }
}

