/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.events.OnlineListSendEvent;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@ComponentInformation(friendlyName="Online List", desc="Lists online players both on command and on player join.")
public class OnlineListComponent
extends BukkitComponent
implements Listener {
    private LocalConfiguration config;

    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public void sendOnlineList(Player[] online, CommandSender sender) {
        String[] lines;
        StringBuilder out = new StringBuilder();
        if (online.length == 0) {
            sender.sendMessage("0 players are online.");
            return;
        }
        out.append(ChatColor.GRAY + "Online (");
        out.append(online.length);
        if (this.config.playersListMaxPlayers) {
            out.append("/");
            out.append(CommandBook.server().getMaxPlayers());
        }
        out.append("): ");
        out.append(ChatColor.WHITE);
        if (this.config.playersListGroupedNames) {
            HashMap groups = new HashMap();
            for (Player player : online) {
                String group;
                String[] playerGroups = CommandBook.inst().getPermissionsResolver().getGroups(player.getName());
                String string = group = playerGroups.length > 0 ? playerGroups[0] : "Default";
                if (groups.containsKey(group)) {
                    ((List)groups.get(group)).add(player);
                    continue;
                }
                ArrayList<Player> list = new ArrayList<Player>();
                list.add(player);
                groups.put(group, list);
            }
            for (Map.Entry entry : groups.entrySet()) {
                out.append("\n");
                out.append(ChatColor.WHITE).append((String)entry.getKey());
                out.append(": ");
                boolean first = true;
                for (Player player : (List)entry.getValue()) {
                    if (!first) {
                        out.append(", ");
                    }
                    if (CommandBook.inst().useDisplayNames) {
                        out.append(player.getDisplayName()).append(ChatColor.WHITE);
                    } else {
                        out.append(player.getName());
                    }
                    first = false;
                }
            }
        } else {
            boolean first = true;
            for (Player player : online) {
                if (!first) {
                    out.append(", ");
                }
                if (CommandBook.inst().useDisplayNames) {
                    out.append(player.getDisplayName()).append(ChatColor.WHITE);
                } else {
                    out.append(player.getName());
                }
                first = false;
            }
        }
        for (String string : lines = out.toString().split("\n")) {
            sender.sendMessage(string);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.config.listOnJoin) {
            return;
        }
        Player player = event.getPlayer();
        CommandBook.callEvent(new OnlineListSendEvent((CommandSender)player));
        this.sendOnlineList(CommandBook.server().getOnlinePlayers(), (CommandSender)player);
    }

    public class Commands {
        @Command(aliases={"who", "list", "playerlist", "online", "players"}, usage="[filter]", desc="Get the list of online users", min=0, max=1)
        @CommandPermissions(value={"commandbook.who"})
        public void who(CommandContext args, CommandSender sender) throws CommandException {
            Player[] online = CommandBook.server().getOnlinePlayers();
            if (!(sender instanceof Player) && CommandBook.inst().crappyWrapperCompat) {
                StringBuilder out = new StringBuilder();
                out.append("Connected players: ");
                boolean first = true;
                for (Player player : online) {
                    if (!first) {
                        out.append(", ");
                    }
                    out.append(CommandBook.inst().useDisplayNames ? player.getDisplayName() : player.getName());
                    out.append(ChatColor.WHITE);
                    first = false;
                }
                sender.sendMessage(out.toString());
                return;
            }
            CommandBook.callEvent(new OnlineListSendEvent(sender));
            if (online.length == 0) {
                sender.sendMessage("0 players are online.");
                return;
            }
            String filter = args.getString(0, "").toLowerCase();
            String string = filter = filter.length() == 0 ? null : filter;
            if (filter == null) {
                OnlineListComponent.this.sendOnlineList(CommandBook.server().getOnlinePlayers(), sender);
                return;
            }
            StringBuilder out = new StringBuilder();
            out.append(ChatColor.GRAY + "Found players (out of ");
            out.append(ChatColor.GRAY + "" + online.length);
            out.append(ChatColor.GRAY + "): ");
            out.append(ChatColor.WHITE);
            boolean first = true;
            for (Player player : online) {
                if (!player.getName().toLowerCase().contains(filter)) break;
                if (!first) {
                    out.append(", ");
                }
                out.append(player.getName());
                first = false;
            }
            if (first) {
                sender.sendMessage(ChatColor.RED + "No players (out of " + online.length + ") matched '" + filter + "'.");
                return;
            }
            sender.sendMessage(out.toString());
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="show-max-players")
        public boolean playersListMaxPlayers = true;
        @Setting(value="grouped-names")
        public boolean playersListGroupedNames;
        @Setting(value="list-on-join")
        public boolean listOnJoin = true;

        private LocalConfiguration() {
        }
    }
}

