/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.util;

import com.sk89q.minecraft.util.commands.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class EntityUtil {
    public static EntityType matchCreatureType(CommandSender sender, String filter, boolean requireSpawnable) throws CommandException {
        for (EntityType type : EntityType.values()) {
            if (!type.name().replace("_", "").equalsIgnoreCase(filter.replace("_", "")) && (type.getName() == null || !type.getName().equalsIgnoreCase(filter) || !type.isSpawnable() && requireSpawnable)) continue;
            return type;
        }
        for (EntityType testType : EntityType.values()) {
            if (testType.getName() == null || !testType.getName().toLowerCase().startsWith(filter.toLowerCase()) || !testType.isSpawnable() && requireSpawnable) continue;
            return testType;
        }
        throw new CommandException("Unknown mob specified! You can choose from the list of: " + EntityUtil.getEntityTypeNameList(requireSpawnable));
    }

    public static String getEntityTypeNameList(boolean requireSpawnable) {
        StringBuilder str = new StringBuilder();
        for (EntityType type : EntityType.values()) {
            if (requireSpawnable && !type.isSpawnable()) continue;
            if (str.length() > 0) {
                str.append(", ");
            }
            str.append(type.getName());
        }
        return str.toString();
    }
}

