/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.bans;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.InfoComponent;
import com.sk89q.commandbook.bans.Ban;
import com.sk89q.commandbook.bans.BanDatabase;
import com.sk89q.commandbook.bans.CSVBanDatabase;
import com.sk89q.commandbook.bans.FlatFileBanDatabase;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;

@ComponentInformation(friendlyName="Bans", desc="A system for kicks and bans.")
public class BansComponent
extends BukkitComponent
implements Listener {
    private BanDatabase bans;
    private LocalConfiguration config;

    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        this.bans = new CSVBanDatabase(CommandBook.inst().getDataFolder());
        this.bans.load();
        if (FlatFileBanDatabase.toImport(CommandBook.inst().getDataFolder())) {
            FlatFileBanDatabase banDb = new FlatFileBanDatabase(CommandBook.inst().getDataFolder(), this);
            banDb.load();
            this.bans.importFrom(banDb);
            File oldBansFile = new File(CommandBook.inst().getDataFolder(), "banned_names.txt");
            oldBansFile.renameTo(new File(oldBansFile.getAbsolutePath() + ".old"));
        }
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
    }

    public void reload() {
        super.reload();
        this.getBanDatabase().load();
        this.configure(this.config);
    }

    public void disable() {
        this.bans.unload();
    }

    public BanDatabase getBanDatabase() {
        return this.bans;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void playerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        try {
            if (!CommandBook.inst().hasPermission((CommandSender)player, "commandbook.bans.exempt")) {
                if (this.getBanDatabase().isBannedName(player.getName())) {
                    event.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.getBanDatabase().getBannedNameMessage(player.getName()));
                } else if (this.getBanDatabase().isBannedAddress(player.getAddress().getAddress())) {
                    event.disallow(PlayerLoginEvent.Result.KICK_BANNED, this.getBanDatabase().getBannedAddressMessage(player.getAddress().getAddress().getHostAddress()));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @EventHandler
    public void playerWhois(InfoComponent.PlayerWhoisEvent event) {
        if (CommandBook.inst().hasPermission(event.getSource(), "commandbook.bans.isbanned")) {
            event.addWhoisInformation(null, "Player " + (this.getBanDatabase().isBannedName(event.getPlayer().getName()) ? "is" : "is not") + " banned.");
        }
    }

    public class ManagementCommands {
        @Command(aliases={"load", "reload", "read"}, usage="", desc="Reload bans from disk", min=0, max=0)
        @CommandPermissions(value={"commandbook.bans.load"})
        public void loadBans(CommandContext args, CommandSender sender) throws CommandException {
            if (!BansComponent.this.getBanDatabase().load()) {
                throw new CommandException("Bans database failed to load entirely. See server console.");
            }
            sender.sendMessage(ChatColor.YELLOW + "Bans database reloaded.");
        }

        @Command(aliases={"save", "write"}, usage="", desc="Save bans to disk", min=0, max=0)
        @CommandPermissions(value={"commandbook.bans.save"})
        public void saveBans(CommandContext args, CommandSender sender) throws CommandException {
            if (!BansComponent.this.getBanDatabase().save()) {
                throw new CommandException("Bans database failed to save entirely. See server console.");
            }
            sender.sendMessage(ChatColor.YELLOW + "Bans database saved.");
        }
    }

    public class Commands {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

        @Command(aliases={"kick"}, usage="<target> [reason...]", desc="Kick a user", flags="os", min=1, max=-1)
        @CommandPermissions(value={"commandbook.kick"})
        public void kick(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            String message = args.argsLength() >= 2 ? args.getJoinedStrings(1) : "Kicked!";
            String broadcastPlayers = "";
            for (Player player : targets) {
                if (!(!CommandBook.inst().hasPermission((CommandSender)player, "commandbook.kick.exempt") || args.hasFlag('o') && CommandBook.inst().hasPermission(sender, "commandbook.kick.exempt.override"))) {
                    sender.sendMessage(ChatColor.RED + "Player " + player.getName() + ChatColor.RED + " is exempt from being kicked!");
                    continue;
                }
                player.kickPlayer(message);
                broadcastPlayers = broadcastPlayers + player.getName() + " ";
                BansComponent.this.getBanDatabase().logKick(player, sender, message);
            }
            if (broadcastPlayers.length() > 0) {
                sender.sendMessage(ChatColor.YELLOW + "Player(s) kicked.");
                if (((BansComponent)BansComponent.this).config.broadcastKicks && !args.hasFlag('s')) {
                    CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " has kicked " + broadcastPlayers + " - " + message);
                }
            }
        }

        @Command(aliases={"ban"}, usage="[-t end ] <target> [reason...]", desc="Ban a user", flags="set:o", min=1, max=-1)
        @CommandPermissions(value={"commandbook.bans.ban"})
        public void ban(CommandContext args, CommandSender sender) throws CommandException {
            String banName;
            String banAddress = null;
            long endDate = args.hasFlag('t') ? CommandBookUtil.matchFutureDate(args.getFlag('t')) : 0L;
            String message = args.argsLength() >= 2 ? args.getJoinedStrings(1) : "Banned!";
            boolean hasExemptOverride = args.hasFlag('o') && CommandBook.inst().hasPermission(sender, "commandbook.bans.exempt.override");
            try {
                Player player = args.hasFlag('e') ? PlayerUtil.matchPlayerExactly(sender, args.getString(0)) : PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                if (CommandBook.inst().hasPermission((CommandSender)player, "commandbook.bans.exempt") && !hasExemptOverride) {
                    throw new CommandException("This player is exempt from being banned! (use -o flag to override if you have commandbook.bans.exempt.override)");
                }
                player.kickPlayer(message);
                BansComponent.this.getBanDatabase().logKick(player, sender, message);
                banName = player.getName();
                sender.sendMessage(ChatColor.YELLOW + player.getName() + " (" + player.getDisplayName() + ChatColor.YELLOW + ") banned and kicked.");
            }
            catch (CommandException e) {
                banName = args.getString(0).replace("\r", "").replace("\n", "").replace("\u0000", "").replace("\b", "");
                sender.sendMessage(ChatColor.YELLOW + banName + " banned.");
            }
            if (((BansComponent)BansComponent.this).config.broadcastBans && !args.hasFlag('s')) {
                CommandBook.server().broadcastMessage(ChatColor.YELLOW + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " has banned " + banName + " - " + message);
            }
            BansComponent.this.getBanDatabase().ban(banName, banAddress, sender, message, endDate);
            if (!BansComponent.this.getBanDatabase().save()) {
                sender.sendMessage(ChatColor.RED + "Bans database failed to save. See console.");
            }
        }

        @Command(aliases={"unban"}, usage="<target>", desc="Unban a user", min=1, max=-1)
        @CommandPermissions(value={"commandbook.bans.unban"})
        public void unban(CommandContext args, CommandSender sender) throws CommandException {
            String message = args.argsLength() >= 2 ? args.getJoinedStrings(1) : "Unbanned!";
            String banName = args.getString(0).replace("\r", "").replace("\n", "").replace("\u0000", "").replace("\b", "");
            if (BansComponent.this.getBanDatabase().unban(banName, null, sender, message)) {
                sender.sendMessage(ChatColor.YELLOW + banName + " unbanned.");
                if (!BansComponent.this.getBanDatabase().save()) {
                    sender.sendMessage(ChatColor.RED + "Bans database failed to save. See console.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + banName + " was not banned.");
            }
        }

        @Command(aliases={"unbanip"}, usage="<target> [reason...]", desc="Unban an IP address", min=1, max=-1)
        @CommandPermissions(value={"commandbook.bans.unban.ip"})
        public void unbanIP(CommandContext args, CommandSender sender) throws CommandException {
            String message;
            String addr = args.getString(0).replace("\r", "").replace("\n", "").replace("\u0000", "").replace("\b", "");
            String string = message = args.argsLength() >= 2 ? args.getJoinedStrings(1) : "Unbanned!";
            if (!BansComponent.this.getBanDatabase().unban(null, addr, sender, message)) {
                sender.sendMessage(ChatColor.YELLOW + addr + " unbanned.");
                if (!BansComponent.this.getBanDatabase().save()) {
                    sender.sendMessage(ChatColor.RED + "Bans database failed to save. See console.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + addr + " was not banned.");
            }
        }

        @Command(aliases={"isbanned"}, usage="<target>", desc="Check if a user is banned", min=1, max=1)
        @CommandPermissions(value={"commandbook.bans.isbanned"})
        public void isBanned(CommandContext args, CommandSender sender) throws CommandException {
            String banName = args.getString(0).replace("\r", "").replace("\n", "").replace("\u0000", "").replace("\b", "");
            if (BansComponent.this.getBanDatabase().isBannedName(banName)) {
                sender.sendMessage(ChatColor.YELLOW + banName + " is banned.");
            } else {
                sender.sendMessage(ChatColor.YELLOW + banName + " NOT banned.");
            }
        }

        @Command(aliases={"baninfo"}, usage="<target>", desc="Check if a user is banned", min=1, max=1)
        @CommandPermissions(value={"commandbook.bans.baninfo"})
        public void banInfo(CommandContext args, CommandSender sender) throws CommandException {
            String banName = args.getString(0).replace("\r", "").replace("\n", "").replace("\u0000", "").replace("\b", "");
            Ban ban = BansComponent.this.getBanDatabase().getBannedName(banName);
            if (ban == null) {
                sender.sendMessage(ChatColor.YELLOW + banName + " is NOT banned.");
            } else {
                sender.sendMessage(ChatColor.YELLOW + "Ban for " + banName + ":" + ban.getAddress() + " for reason: '" + ban.getReason() + "' until " + (ban.getEnd() == 0L ? " forever" : this.dateFormat.format(new Date(ban.getEnd()))));
            }
        }

        @Command(aliases={"bans"}, desc="Ban management")
        @NestedCommand(value={ManagementCommands.class})
        public void bans() throws CommandException {
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="message")
        public String banMessage = "You have been banned";
        @Setting(value="broadcast-bans")
        public boolean broadcastBans;
        @Setting(value="broadcast-kicks")
        public boolean broadcastKicks;

        private LocalConfiguration() {
        }
    }
}

