/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.locations;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.locations.WrappedSpawnManager;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerIteratorAction;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import java.io.File;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@ComponentInformation(friendlyName="Spawn Locations", desc="Allows exact spawn locations for players, as well as getting and setting the world's spawn.")
public class SpawnLocationsComponent
extends BukkitComponent
implements Listener {
    private WrappedSpawnManager spawns;
    private LocalConfiguration config;

    public void enable() {
        this.spawns = new WrappedSpawnManager(new File(CommandBook.inst().getDataFolder(), "spawns.yml"));
        this.config = this.configure(new LocalConfiguration());
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
    }

    public void reload() {
        super.reload();
        this.spawns.load();
    }

    public WrappedSpawnManager getSpawnManager() {
        return this.spawns;
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        if (this.config.exactSpawn && !event.isBedSpawn()) {
            event.setRespawnLocation(this.spawns.getWorldSpawn(event.getPlayer().getWorld()));
        }
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Location loc = event.getTo();
        if (event.isCancelled()) {
            return;
        }
        if (loc.equals((Object)loc.getWorld().getSpawnLocation())) {
            event.setTo(this.spawns.getWorldSpawn(loc.getWorld()));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        if (!event.getPlayer().hasPlayedBefore() && this.config.exactSpawn) {
            event.getPlayer().teleport(this.spawns.getWorldSpawn(event.getPlayer().getWorld()));
        }
    }

    public class Commands {
        @Command(aliases={"spawn"}, usage="[player]", desc="Teleport to spawn", min=0, max=1)
        @CommandPermissions(value={"commandbook.spawn"})
        public void spawn(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets;
            if (args.argsLength() == 1) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                for (Player target : targets) {
                    if (target == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.spawn.other");
                    break;
                }
            } else {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
            }
            new PlayerIteratorAction(sender){

                public void perform(Player player) {
                    player.teleport(SpawnLocationsComponent.this.getSpawnManager().getWorldSpawn(player.getWorld()));
                }

                public void onCaller(Player player) {
                    player.sendMessage(ChatColor.YELLOW + "Teleported to spawn.");
                }

                public void onVictim(CommandSender sender, Player player) {
                    player.sendMessage(ChatColor.YELLOW + "Teleported to spawn by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + ".");
                }

                public void onInformMany(CommandSender sender, int affected) {
                    sender.sendMessage(ChatColor.YELLOW.toString() + affected + " teleported to spawn.");
                }
            }.iterate(targets);
        }

        @Command(aliases={"setspawn"}, usage="[location]", desc="Change spawn location", flags="", min=0, max=1)
        @CommandPermissions(value={"commandbook.setspawn"})
        public void setspawn(CommandContext args, CommandSender sender) throws CommandException {
            Location loc;
            World world;
            if (args.argsLength() == 0) {
                Player player = PlayerUtil.checkPlayer(sender);
                world = player.getWorld();
                loc = player.getLocation();
            } else {
                loc = LocationUtil.matchLocation(sender, args.getString(0));
                world = loc.getWorld();
            }
            SpawnLocationsComponent.this.getSpawnManager().setWorldSpawn(loc);
            sender.sendMessage(ChatColor.YELLOW + "Spawn location of '" + world.getName() + "' set!");
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="exact-spawn")
        public boolean exactSpawn;

        private LocalConfiguration() {
        }
    }
}

