/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.session;

import com.sk89q.commandbook.session.PersistentSession;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.config.Setting;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UserSession
extends PersistentSession {
    public static final String CONSOLE_NAME = "#console";
    private static final long MAX_AGE = TimeUnit.DAYS.toMillis(10L);
    private static final long RECONNECT_GRACE = TimeUnit.MINUTES.toMillis(1L);
    private static final long BRINGABLE_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long TP_REQUEST_WAIT_TIME = TimeUnit.SECONDS.toMillis(30L);
    private static final int LOCATION_HISTORY_SIZE = 10;
    @Setting(value="messaging.last-recipient")
    private String lastRecipient = null;
    @Setting(value="messaging.last-recipient-time")
    private long lastRecipientTime = 0L;
    private boolean hasThor = false;
    @Setting(value="idle-status")
    private String idleStatus = null;
    @Setting(value="confirm-command")
    private String commandToConfirm;
    @Setting(value="teleport.bringable")
    private Map<String, Long> bringable = new HashMap<String, Long>();
    @Setting(value="teleport.requests")
    private final Map<String, Long> teleportRequests = new HashMap<String, Long>();
    private final LinkedList<Location> locationHistory = new LinkedList();
    private Location ignoreTeleportLocation;

    protected UserSession() {
        super(MAX_AGE);
    }

    public void handleReconnect(CommandSender player) {
        super.handleReconnect(player);
        if (this.getGoneTime() >= RECONNECT_GRACE) {
            this.lastRecipient = null;
            this.bringable = new HashMap<String, Long>();
        }
    }

    public void handleDisconnect() {
        super.handleDisconnect();
        this.hasThor = false;
    }

    public String getLastRecipient() {
        return this.lastRecipient;
    }

    public void setLastRecipient(CommandSender target) {
        this.lastRecipient = target instanceof Player ? target.getName() : CONSOLE_NAME;
    }

    public void setNewLastRecipient(CommandSender target) {
        long now = System.currentTimeMillis();
        if (this.lastRecipient == null || now - this.lastRecipientTime > 1000L) {
            this.setLastRecipient(target);
            this.lastRecipientTime = now;
        }
    }

    public boolean hasThor() {
        return this.hasThor;
    }

    public void setHasThor(boolean hasThor) {
        this.hasThor = hasThor;
    }

    public void addBringable(Player player) {
        this.bringable.put(player.getName(), System.currentTimeMillis());
    }

    public void removeBringable(Player player) {
        this.bringable.put(player.getName(), System.currentTimeMillis());
    }

    public boolean isBringable(Player player) {
        long now = System.currentTimeMillis();
        Long time = this.bringable.remove(player.getName());
        return time != null && now - time < BRINGABLE_TIME;
    }

    public void checkLastTeleportRequest(Player target) throws CommandException {
        long now = System.currentTimeMillis();
        Long time = this.teleportRequests.remove(target.getName());
        if (time != null && now - time < TP_REQUEST_WAIT_TIME) {
            throw new CommandException("Wait a bit before asking again.");
        }
        this.teleportRequests.put(target.getName(), now);
    }

    public void rememberLocation(Location location) {
        if (this.locationHistory.size() > 0 && this.locationHistory.peek().equals((Object)location)) {
            return;
        }
        this.locationHistory.add(0, location);
        while (this.locationHistory.size() > 10) {
            this.locationHistory.poll();
        }
    }

    public void rememberLocation(Player player) {
        this.rememberLocation(player.getLocation());
    }

    public Location popLastLocation() {
        return this.locationHistory.poll();
    }

    public String getIdleStatus() {
        return this.idleStatus;
    }

    public void setIdleStatus(String status) {
        this.idleStatus = status;
    }

    public void setIgnoreLocation(Location loc) {
        this.ignoreTeleportLocation = loc;
    }

    public Location getIgnoreLocation() {
        return this.ignoreTeleportLocation;
    }

    public boolean checkOrQueueConfirmed(String command) {
        if (this.commandToConfirm != null) {
            return true;
        }
        this.commandToConfirm = command;
        return false;
    }

    public String getCommandToConfirm(boolean clear) {
        if (clear) {
            String ret = this.commandToConfirm;
            this.commandToConfirm = null;
            return ret;
        }
        return this.commandToConfirm;
    }
}

