/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.events.CommandSenderMessageEvent;
import com.sk89q.commandbook.events.SharedMessageEvent;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChatEvent;

@ComponentInformation(friendlyName="Messaging", desc="Commands that involve direct player <-> player or player <-> admincommunication are handled through this component.")
@Depend(components={SessionComponent.class})
public class MessagingComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;

    public void enable() {
        this.config = this.configure(new LocalConfiguration());
        this.registerCommands(Commands.class);
        CommandBook.registerEvents(this);
    }

    public void reload() {
        super.reload();
        this.configure(this.config);
    }

    public void messagePlayer(CommandSender sender, String target, String message) throws CommandException {
        CommandSender receiver = PlayerUtil.matchPlayerOrConsole(sender, target);
        String status = this.sessions.getSession(receiver).getIdleStatus();
        if (status != null) {
            sender.sendMessage(ChatColor.GRAY + PlayerUtil.toColoredName(receiver, ChatColor.YELLOW) + " is afk. " + "They might not see your message." + (status.trim().length() == 0 ? "" : " (" + status + ")"));
        }
        receiver.sendMessage(ChatColor.GRAY + "(From " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + "): " + ChatColor.WHITE + message);
        sender.sendMessage(ChatColor.GRAY + "(To " + PlayerUtil.toColoredName(receiver, ChatColor.YELLOW) + "): " + ChatColor.WHITE + message);
        CommandBook.logger().info("(PM) " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " -> " + PlayerUtil.toColoredName(receiver, ChatColor.YELLOW) + ": " + message);
        this.sessions.getSession(sender).setLastRecipient(receiver);
        this.sessions.getSession(receiver).setNewLastRecipient(sender);
    }

    @EventHandler
    public void onChat(PlayerChatEvent event) {
        String message;
        int spaceIndex;
        if (this.sessions.getAdminSession(event.getPlayer()).isMute()) {
            event.getPlayer().sendMessage(ChatColor.RED + "You are muted.");
            event.setCancelled(true);
        } else if (event.getMessage().startsWith("@") && this.config.twitterStyle && (spaceIndex = (message = event.getMessage()).indexOf(" ")) > -1) {
            try {
                String name = message.substring(1, spaceIndex);
                if (name.length() <= 0) {
                    return;
                }
                this.messagePlayer((CommandSender)event.getPlayer(), name, message.substring(spaceIndex + 1));
            }
            catch (CommandException e) {
                event.getPlayer().sendMessage(ChatColor.RED + e.getMessage());
            }
            event.setCancelled(true);
        }
    }

    public class Commands {
        @Command(aliases={"me"}, usage="<message...>", desc="Send an action message", min=1, max=-1)
        @CommandPermissions(value={"commandbook.say.me"})
        public void me(CommandContext args, CommandSender sender) throws CommandException {
            if (sender instanceof Player && MessagingComponent.this.sessions.getAdminSession((Player)sender).isMute()) {
                sender.sendMessage(ChatColor.RED + "You are muted.");
                return;
            }
            String name = PlayerUtil.toColoredName(sender, ChatColor.YELLOW);
            String msg = args.getJoinedStrings(0);
            CommandBook.callEvent(new SharedMessageEvent(name + " " + msg));
            CommandBook.server().broadcastMessage("* " + name + " " + msg);
        }

        @Command(aliases={"say"}, usage="<message...>", desc="Send a message", min=1, max=-1)
        @CommandPermissions(value={"commandbook.say"})
        public void say(CommandContext args, CommandSender sender) throws CommandException {
            if (sender instanceof Player && MessagingComponent.this.sessions.getAdminSession((Player)sender).isMute()) {
                sender.sendMessage(ChatColor.RED + "You are muted.");
                return;
            }
            String msg = args.getJoinedStrings(0);
            if (sender instanceof Player && CommandBook.callEvent(new PlayerChatEvent((Player)sender, msg)).isCancelled()) {
                return;
            }
            CommandBook.callEvent(new CommandSenderMessageEvent(sender, msg));
            if (sender instanceof Player) {
                CommandBook.server().broadcastMessage("<" + PlayerUtil.toColoredName(sender, ChatColor.WHITE) + "> " + args.getJoinedStrings(0));
            } else {
                CommandBook.server().broadcastMessage(CommandBookUtil.replaceColorMacros(((MessagingComponent)MessagingComponent.this).config.consoleSayFormat).replace("%s", args.getJoinedStrings(0)));
            }
        }

        @Command(aliases={"msg", "message", "whisper", "pm", "tell"}, usage="<target> <message...>", desc="Private message a user", min=2, max=-1)
        @CommandPermissions(value={"commandbook.msg"})
        public void msg(CommandContext args, CommandSender sender) throws CommandException {
            MessagingComponent.this.messagePlayer(sender, args.getString(0), args.getJoinedStrings(1));
        }

        @Command(aliases={"reply", "r"}, usage="<message...>", desc="Reply to last user", min=1, max=-1)
        @CommandPermissions(value={"commandbook.msg"})
        public void reply(CommandContext args, CommandSender sender) throws CommandException {
            String message = args.getJoinedStrings(0);
            String lastRecipient = MessagingComponent.this.sessions.getSession(sender).getLastRecipient();
            if (lastRecipient == null) {
                sender.sendMessage(ChatColor.RED + "You haven't messaged anyone.");
                return;
            }
            CommandSender receiver = PlayerUtil.matchPlayerOrConsole(sender, lastRecipient);
            if (receiver instanceof Player && MessagingComponent.this.sessions.getSession(receiver).getIdleStatus() != null) {
                String status = MessagingComponent.this.sessions.getSession(receiver).getIdleStatus();
                sender.sendMessage(ChatColor.GRAY + PlayerUtil.toColoredName(receiver, ChatColor.YELLOW) + " is afk. " + "They might not see your message." + (status.isEmpty() ? "" : " (" + status + ")"));
            }
            receiver.sendMessage(ChatColor.GRAY + "(From " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + "): " + ChatColor.WHITE + message);
            sender.sendMessage(ChatColor.GRAY + "(To " + PlayerUtil.toColoredName(receiver, ChatColor.YELLOW) + "): " + ChatColor.WHITE + message);
            CommandBook.logger().info("(PM) " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW) + " -> " + PlayerUtil.toColoredName(receiver, ChatColor.YELLOW) + ": " + message);
            MessagingComponent.this.sessions.getSession(receiver).setNewLastRecipient(sender);
        }

        @Command(aliases={"afk", "away"}, usage="", desc="Set yourself as away", flags="", min=0, max=-1)
        @CommandPermissions(value={"commandbook.away"})
        public void afk(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            if (MessagingComponent.this.sessions.getSession((CommandSender)player).getIdleStatus() == null) {
                String status = "";
                if (args.argsLength() > 0) {
                    status = args.getJoinedStrings(0);
                    MessagingComponent.this.sessions.getSession((CommandSender)player).setIdleStatus(status);
                }
                player.sendMessage(ChatColor.YELLOW + (status.isEmpty() ? "Set as away" : "Set away status to \"" + status + "\"") + ". To return, type /afk again.");
            } else {
                player.sendMessage(ChatColor.YELLOW + "You are no longer away.");
                MessagingComponent.this.sessions.getSession((CommandSender)player).setIdleStatus(null);
            }
        }

        @Command(aliases={"mute"}, usage="<target>", desc="Mute a player", flags="o", min=1, max=1)
        @CommandPermissions(value={"commandbook.mute"})
        public void mute(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
            if (!(!CommandBook.inst().hasPermission((CommandSender)player, "commandbook.mute.exempt") || args.hasFlag('o') && CommandBook.inst().hasPermission(sender, "commandbook.mute.exempt.override"))) {
                throw new CommandException("Player " + PlayerUtil.toName(sender) + " is exempt from being muted!");
            }
            if (!MessagingComponent.this.sessions.getAdminSession(player).setMute(true)) {
                if (player != sender) {
                    player.sendMessage(ChatColor.YELLOW + "You've been muted by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
                }
            } else {
                throw new CommandException("Player " + PlayerUtil.toName((CommandSender)player) + " is already muted!");
            }
            sender.sendMessage(ChatColor.YELLOW + "You've muted " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
        }

        @Command(aliases={"unmute"}, usage="<target>", desc="Unmute a player", min=1, max=1)
        @CommandPermissions(value={"commandbook.mute"})
        public void unmute(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
            if (MessagingComponent.this.sessions.getAdminSession(player).setMute(false)) {
                if (player != sender) {
                    player.sendMessage(ChatColor.YELLOW + "You've been unmuted by " + PlayerUtil.toColoredName(sender, ChatColor.YELLOW));
                }
            } else {
                throw new CommandException("Player " + PlayerUtil.toName((CommandSender)player) + " was not muted!");
            }
            sender.sendMessage(ChatColor.YELLOW + "You've unmuted " + PlayerUtil.toColoredName((CommandSender)player, ChatColor.YELLOW));
        }

        @Command(aliases={"broadcast"}, usage="<message...>", desc="Broadcast a message", min=1, max=-1)
        @CommandPermissions(value={"commandbook.broadcast"})
        public void broadcast(CommandContext args, CommandSender sender) throws CommandException {
            CommandBook.server().broadcastMessage(CommandBookUtil.replaceColorMacros(((MessagingComponent)MessagingComponent.this).config.broadcastFormat).replace("%s", args.getJoinedStrings(0)));
        }
    }

    private static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="console-say-format")
        public String consoleSayFormat = "<`r*Console`w> %s";
        @Setting(value="broadcast-format")
        public String broadcastFormat = "`r[Broadcast] %s";
        @Setting(value="twitter-style")
        public boolean twitterStyle = true;

        private LocalConfiguration() {
        }
    }
}

