/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.PermissionsResolver;
import java.util.ArrayList;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.util.config.Configuration;

public class DinnerPermsResolver
implements PermissionsResolver {
    private static final String GROUP_PREFIX = "group.";
    private final Server server;

    public DinnerPermsResolver(Server server) {
        this.server = server;
    }

    public static PermissionsResolver factory(Server server, Configuration config) {
        if (!config.getBoolean("dinnerperms", true)) {
            return null;
        }
        return new DinnerPermsResolver(server);
    }

    public void load() {
    }

    public boolean hasPermission(String name, String permission) {
        Player player = this.server.getPlayerExact(name);
        if (player == null) {
            return false;
        }
        if (player.hasPermission("*") || player.hasPermission(permission)) {
            return true;
        }
        int dotPos = permission.lastIndexOf(".");
        while (dotPos > -1) {
            if (player.hasPermission(permission.substring(0, dotPos + 1) + "*")) {
                return true;
            }
            dotPos = permission.lastIndexOf(".", dotPos - 1);
        }
        return false;
    }

    public boolean hasPermission(String worldName, String name, String permission) {
        return this.hasPermission(name, permission);
    }

    public boolean inGroup(String name, String group) {
        Player player = this.server.getPlayer(name);
        if (player == null) {
            return false;
        }
        return player.hasPermission(GROUP_PREFIX + group);
    }

    public String[] getGroups(String name) {
        Player player = this.server.getPlayer(name);
        if (player == null) {
            return new String[0];
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        for (PermissionAttachmentInfo permAttach : player.getEffectivePermissions()) {
            String perm = permAttach.getPermission();
            if (!perm.startsWith(GROUP_PREFIX) || !permAttach.getValue()) continue;
            groupNames.add(perm.substring(GROUP_PREFIX.length(), perm.length()));
        }
        return groupNames.toArray(new String[groupNames.size()]);
    }

    public String getDetectionMessage() {
        return "Using the Bukkit Permissions API.";
    }
}

