/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.nijikokun.bukkit.Permissions.Permissions;
import com.sk89q.bukkit.migration.PermissionsResolver;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.config.Configuration;

public class NijiPermissionsResolver
implements PermissionsResolver {
    private Server server;
    private Permissions api;

    public static PermissionsResolver factory(Server server, Configuration config) {
        PluginManager pluginManager = server.getPluginManager();
        Plugin plugin = pluginManager.getPlugin("Permissions");
        if (plugin == null || !(plugin instanceof Permissions)) {
            return null;
        }
        if (config.getBoolean("ignore-nijiperms-bridges", true) && NijiPermissionsResolver.isFakeNijiPerms(plugin)) {
            return null;
        }
        return new NijiPermissionsResolver(server, (Permissions)plugin);
    }

    public void load() {
    }

    public NijiPermissionsResolver(Server server, Permissions plugin) {
        this.server = server;
        this.api = plugin;
    }

    /*
     * Loose catch block
     */
    public boolean hasPermission(String name, String permission) {
        Player player;
        block5: {
            player = this.server.getPlayer(name);
            if (player != null) break block5;
            return false;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    return false;
                }
            }
        }
        try {
            return this.api.getHandler().has(player, permission);
        }
        catch (Throwable t) {
            return Permissions.Security.permission(player, permission);
        }
    }

    public boolean hasPermission(String worldName, String name, String permission) {
        try {
            return this.api.getHandler().has(worldName, name, permission);
        }
        catch (Throwable t) {
            try {
                return this.api.getHandler().has(this.server.getPlayer(name), permission);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                return false;
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean inGroup(String name, String group) {
        Player player;
        block5: {
            player = this.server.getPlayer(name);
            if (player != null) break block5;
            return false;
            {
                catch (Throwable t) {
                    t.printStackTrace();
                    return false;
                }
            }
        }
        try {
            return this.api.getHandler().inGroup(player.getWorld().getName(), name, group);
        }
        catch (Throwable t) {
            return Permissions.Security.inGroup(name, group);
        }
    }

    public String[] getGroups(String name) {
        try {
            String[] groups;
            block6: {
                Player player = this.server.getPlayer(name);
                if (player == null) {
                    return new String[0];
                }
                groups = null;
                try {
                    groups = this.api.getHandler().getGroups(player.getWorld().getName(), player.getName());
                }
                catch (Throwable t) {
                    String group = Permissions.Security.getGroup(player.getWorld().getName(), player.getName());
                    if (group == null) break block6;
                    groups = new String[]{group};
                }
            }
            if (groups == null) {
                return new String[0];
            }
            return groups;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new String[0];
        }
    }

    @Deprecated
    public static boolean checkRealNijiPerms(boolean ignoreBridges) {
        if (!ignoreBridges) {
            return true;
        }
        PluginCommand permsCommand = Bukkit.getServer().getPluginCommand("permissions");
        if (permsCommand == null) {
            return false;
        }
        return permsCommand.getPlugin().getDescription().getName().equals("Permissions");
    }

    public static boolean isFakeNijiPerms(Plugin plugin) {
        PluginCommand permsCommand = Bukkit.getServer().getPluginCommand("permissions");
        return !permsCommand.getPlugin().equals(plugin);
    }

    public String getDetectionMessage() {
        return "Permissions plugin detected! Using Permissions plugin for permissions.";
    }

    public static class PluginAccessException
    extends Exception {
        private static final long serialVersionUID = 7044832912491608706L;
    }
}

