/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.PermissionsResolver;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.util.config.Configuration;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;

public class PermissionsExResolver
implements PermissionsResolver {
    private final PermissionManager manager;
    private final Server server;

    public static PermissionsResolver factory(Server server, Configuration config) {
        PermissionManager manager = (PermissionManager)server.getServicesManager().load(PermissionManager.class);
        if (manager == null) {
            return null;
        }
        return new PermissionsExResolver(server, manager);
    }

    public PermissionsExResolver(Server server, PermissionManager manager) {
        this.server = server;
        this.manager = manager;
    }

    public void load() {
    }

    public boolean hasPermission(String name, String permission) {
        Player player = this.server.getPlayer(name);
        return this.manager.has(name, permission, player == null ? null : player.getWorld().getName());
    }

    public boolean hasPermission(String worldName, String name, String permission) {
        return this.manager.has(name, permission, worldName);
    }

    public boolean inGroup(String player, String group) {
        PermissionUser user = this.manager.getUser(player);
        if (user == null) {
            return false;
        }
        return user.inGroup(group);
    }

    public String[] getGroups(String player) {
        PermissionUser user = this.manager.getUser(player);
        if (user == null) {
            return new String[0];
        }
        return user.getGroupsNames();
    }

    public String getDetectionMessage() {
        return "PermissionsEx detected! Using PermissionsEx for permissions.";
    }
}

