/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.ContainerBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.Chunk;
import com.sk89q.worldedit.data.DataException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnaceBlock
extends BaseBlock
implements TileEntityBlock,
ContainerBlock {
    private BaseItemStack[] items;
    private short burnTime;
    private short cookTime;

    public FurnaceBlock(int type) {
        super(type);
        this.items = new BaseItemStack[2];
    }

    public FurnaceBlock(int type, int data) {
        super(type, data);
        this.items = new BaseItemStack[2];
    }

    public FurnaceBlock(int type, int data, BaseItemStack[] items) {
        super(type, data);
        this.items = items;
    }

    @Override
    public BaseItemStack[] getItems() {
        return this.items;
    }

    @Override
    public void setItems(BaseItemStack[] items) {
        this.items = items;
    }

    public short getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(short burnTime) {
        this.burnTime = burnTime;
    }

    public short getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(short cookTime) {
        this.cookTime = cookTime;
    }

    @Override
    public String getTileEntityID() {
        return "Furnace";
    }

    @Override
    public Map<String, Tag> toTileEntityNBT() throws DataException {
        ArrayList<Tag> itemsList = new ArrayList<Tag>();
        for (int i = 0; i < this.items.length; ++i) {
            BaseItemStack item = this.items[i];
            if (item == null) continue;
            HashMap<String, Tag> data = new HashMap<String, Tag>();
            CompoundTag itemTag = new CompoundTag("Items", data);
            data.put("id", new ShortTag("id", (short)item.getType()));
            data.put("Damage", new ShortTag("Damage", item.getDamage()));
            data.put("Count", new ByteTag("Count", (byte)item.getAmount()));
            data.put("Slot", new ByteTag("Slot", (byte)i));
            itemsList.add(itemTag);
        }
        HashMap<String, Tag> values = new HashMap<String, Tag>();
        values.put("Items", new ListTag("Items", CompoundTag.class, itemsList));
        values.put("BurnTime", new ShortTag("BurnTime", this.burnTime));
        values.put("CookTime", new ShortTag("CookTime", this.cookTime));
        return values;
    }

    @Override
    public void fromTileEntityNBT(Map<String, Tag> values) throws DataException {
        if (values == null) {
            return;
        }
        Tag t = values.get("id");
        if (!(t instanceof StringTag) || !((StringTag)t).getValue().equals("Furnace")) {
            throw new DataException("'Furnace' tile entity expected");
        }
        ListTag items = (ListTag)Chunk.getChildTag(values, "Items", ListTag.class);
        BaseItemStack[] newItems = new BaseItemStack[27];
        Iterator i$ = items.getValue().iterator();
        while (i$.hasNext()) {
            Tag tag = (Tag)i$.next();
            if (!(tag instanceof CompoundTag)) {
                throw new DataException("CompoundTag expected as child tag of Trap Items");
            }
            CompoundTag item = (CompoundTag)tag;
            Object itemValues = item.getValue();
            short id = ((ShortTag)Chunk.getChildTag((Map<String, Tag>)itemValues, "id", ShortTag.class)).getValue();
            short damage = ((ShortTag)Chunk.getChildTag((Map<String, Tag>)itemValues, "Damage", ShortTag.class)).getValue();
            byte count = ((ByteTag)Chunk.getChildTag((Map<String, Tag>)itemValues, "Count", ByteTag.class)).getValue();
            byte slot = ((ByteTag)Chunk.getChildTag((Map<String, Tag>)itemValues, "Slot", ByteTag.class)).getValue();
            if (slot < 0 || slot > 26) continue;
            newItems[slot] = new BaseItemStack(id, count, damage);
        }
        this.items = newItems;
        t = values.get("BurnTime");
        if (t instanceof ShortTag) {
            this.burnTime = ((ShortTag)t).getValue();
        }
        if ((t = values.get("CookTime")) instanceof ShortTag) {
            this.cookTime = ((ShortTag)t).getValue();
        }
    }
}

