/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.bukkit.migration.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditOperation;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.SessionTimer;
import com.sk89q.worldedit.bukkit.WorldEditAPI;
import com.sk89q.worldedit.bukkit.WorldEditCriticalPlayerListener;
import com.sk89q.worldedit.bukkit.WorldEditPlayerListener;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Polygonal2DSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldEditPlugin
extends JavaPlugin {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private ServerInterface server;
    private WorldEdit controller;
    private WorldEditAPI api;
    private BukkitConfiguration config;
    private PermissionsResolverManager perms;

    public void onEnable() {
        logger.info("WorldEdit " + this.getDescription().getVersion() + " enabled.");
        this.getDataFolder().mkdirs();
        this.createDefaultConfiguration("config.yml");
        this.config = new BukkitConfiguration(this.getConfiguration(), logger);
        this.perms = new PermissionsResolverManager((Plugin)this, "WorldEdit", logger);
        this.loadConfiguration();
        this.server = new BukkitServerInterface(this, this.getServer());
        this.controller = new WorldEdit(this.server, this.config);
        this.api = new WorldEditAPI(this);
        this.registerEvents();
        this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)new SessionTimer(this.controller, this.getServer()), 120L, 120L);
    }

    public void onDisable() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            BukkitPlayer lPlayer = this.wrapPlayer(player);
            if (!this.controller.getSession(lPlayer).hasCUISupport()) continue;
            ((LocalPlayer)lPlayer).dispatchCUIHandshake();
        }
        this.controller.clearSessions();
        this.config.unload();
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.getConfiguration().load();
        this.config.unload();
        this.config.load();
        this.perms.load();
    }

    protected void registerEvents() {
        new WorldEditPlayerListener(this);
        new WorldEditCriticalPlayerListener(this);
    }

    public void registerEvent(String typeName, Listener listener, Event.Priority priority) {
        try {
            Event.Type type = Event.Type.valueOf((String)typeName);
            this.getServer().getPluginManager().registerEvent(type, listener, priority, (Plugin)this);
        }
        catch (IllegalArgumentException e) {
            logger.info("WorldEdit: Unable to register missing event type " + typeName);
        }
    }

    public void registerEvent(String typeName, Listener listener) {
        this.registerEvent(typeName, listener, Event.Priority.Normal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void createDefaultConfiguration(String name) {
        block25: {
            File actual = new File(this.getDataFolder(), name);
            if (!actual.exists()) {
                InputStream input = null;
                try {
                    JarFile file = new JarFile(this.getFile());
                    ZipEntry copy = file.getEntry("defaults" + File.separator + name);
                    if (copy == null) {
                        throw new FileNotFoundException();
                    }
                    input = file.getInputStream(copy);
                }
                catch (IOException e) {
                    logger.severe(this.getDescription().getName() + ": Unable to read default configuration: " + name);
                }
                if (input != null) {
                    FileOutputStream output = null;
                    output = new FileOutputStream(actual);
                    byte[] buf = new byte[8192];
                    int length = 0;
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                    logger.info(this.getDescription().getName() + ": Default configuration file written: " + name);
                    Object var8_9 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block25;
                    }
                    catch (IOException e2) {}
                    break block25;
                    {
                        catch (IOException e) {
                            e.printStackTrace();
                            Object var8_10 = null;
                            try {
                                if (input != null) {
                                    input.close();
                                }
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            try {
                                if (output != null) {
                                    output.close();
                                }
                                break block25;
                            }
                            catch (IOException e2) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        try {
                            if (output != null) {
                                output.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        String[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = "/" + cmd.getName();
        this.controller.handleCommand(this.wrapPlayer(player), split);
        return true;
    }

    public LocalSession getSession(Player player) {
        return this.controller.getSession(this.wrapPlayer(player));
    }

    public EditSession createEditSession(Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = this.controller.getSession(wePlayer);
        BlockBag blockBag = session.getBlockBag(wePlayer);
        EditSession editSession = new EditSession(((LocalPlayer)wePlayer).getWorld(), session.getBlockChangeLimit(), blockBag);
        editSession.enableQueue();
        return editSession;
    }

    public void remember(Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = this.controller.getSession(wePlayer);
        session.remember(editSession);
        editSession.flushQueue();
        this.controller.flushBlockBag(wePlayer, editSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Player player, WorldEditOperation op) throws Throwable {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = this.controller.getSession(wePlayer);
        EditSession editSession = this.createEditSession(player);
        try {
            op.run(session, wePlayer, editSession);
            Object var7_6 = null;
            this.remember(player, editSession);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.remember(player, editSession);
            throw throwable;
        }
    }

    @Deprecated
    public WorldEditAPI getAPI() {
        return this.api;
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return this.perms;
    }

    public BukkitPlayer wrapPlayer(Player player) {
        return new BukkitPlayer(this, this.server, player);
    }

    public ServerInterface getServerInterface() {
        return this.server;
    }

    public WorldEdit getWorldEdit() {
        return this.controller;
    }

    public Selection getSelection(Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Null player not allowed");
        }
        if (!player.isOnline()) {
            throw new IllegalArgumentException("Offline player not allowed");
        }
        LocalSession session = this.controller.getSession(this.wrapPlayer(player));
        RegionSelector selector = session.getRegionSelector();
        try {
            Region region = selector.getRegion();
            World world = ((BukkitWorld)session.getSelectionWorld()).getWorld();
            if (region instanceof CuboidRegion) {
                return new CuboidSelection(world, selector, (CuboidRegion)region);
            }
            if (region instanceof Polygonal2DRegion) {
                return new Polygonal2DSelection(world, selector, (Polygonal2DRegion)region);
            }
            return null;
        }
        catch (IncompleteRegionException e) {
            return null;
        }
    }

    public void setSelection(Player player, Selection selection) {
        if (player == null) {
            throw new IllegalArgumentException("Null player not allowed");
        }
        if (!player.isOnline()) {
            throw new IllegalArgumentException("Offline player not allowed");
        }
        if (selection == null) {
            throw new IllegalArgumentException("Null selection not allowed");
        }
        LocalSession session = this.controller.getSession(this.wrapPlayer(player));
        RegionSelector sel = selection.getRegionSelector();
        session.setRegionSelector(new BukkitWorld(player.getWorld()), sel);
        session.dispatchCUISelection(this.wrapPlayer(player));
    }
}

