/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.commands.SnapshotCommands;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.data.MissingWorldException;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.snapshots.InvalidSnapshotException;
import com.sk89q.worldedit.snapshots.Snapshot;
import com.sk89q.worldedit.snapshots.SnapshotRestore;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SnapshotUtilCommands {
    private static Logger logger = Logger.getLogger("Minecraft.WorldEdit");

    @Command(aliases={"snapshot", "snap"}, desc="Snapshot commands")
    @NestedCommand(value={SnapshotCommands.class})
    public static void snapshot(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"restore", "/restore"}, usage="[snapshot]", desc="Restore the selection from a snapshot", min=0, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public static void restore(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Snapshot snapshot;
        Region region;
        block22: {
            LocalConfiguration config = we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("Snapshot/backup restore is not configured.");
                return;
            }
            region = session.getSelection(player.getWorld());
            if (args.argsLength() > 0) {
                try {
                    snapshot = config.snapshotRepo.getSnapshot(args.getString(0));
                }
                catch (InvalidSnapshotException e) {
                    player.printError("That snapshot does not exist or is not available.");
                    return;
                }
            } else {
                snapshot = session.getSnapshot();
            }
            if (snapshot == null) {
                try {
                    snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) break block22;
                    player.printError("No snapshots were found. See console for details.");
                    File dir = config.snapshotRepo.getDirectory();
                    try {
                        logger.info("WorldEdit found no snapshots: looked in: " + dir.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                    }
                    return;
                }
                catch (MissingWorldException ex) {
                    player.printError("No snapshots were found for this world.");
                    return;
                }
            }
        }
        ChunkStore chunkStore = null;
        try {
            chunkStore = snapshot.getChunkStore();
            player.print("Snapshot '" + snapshot.getName() + "' loaded; now restoring...");
        }
        catch (DataException e) {
            player.printError("Failed to load snapshot: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            player.printError("Failed to load snapshot: " + e.getMessage());
            return;
        }
        try {
            SnapshotRestore restore = new SnapshotRestore(chunkStore, region);
            restore.restore(editSession);
            if (restore.hadTotalFailure()) {
                String error = restore.getLastErrorMessage();
                if (error != null) {
                    player.printError("Errors prevented any blocks from being restored.");
                    player.printError("Last error: " + error);
                } else {
                    player.printError("No chunks could be loaded. (Bad archive?)");
                }
            } else {
                player.print(String.format("Restored; %d missing chunks and %d other errors.", restore.getMissingChunks().size(), restore.getErrorChunks().size()));
            }
            Object var12_17 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            try {
                chunkStore.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            chunkStore.close();
        }
        catch (IOException e) {}
    }
}

