/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools;

import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.tools.BrushTool;
import com.sk89q.worldedit.tools.DoubleActionTraceTool;

public class DistanceWand
extends BrushTool
implements DoubleActionTraceTool {
    public DistanceWand() {
        super("worldedit.wand");
    }

    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.wand");
    }

    public boolean actSecondary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session) {
        if (session.isToolControlEnabled() && player.hasPermission("worldedit.selection.pos")) {
            WorldVector target = this.getTarget(player);
            if (target == null) {
                return true;
            }
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectPrimary(target)) {
                selector.explainPrimarySelection(player, session, target);
            }
            return true;
        }
        return false;
    }

    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session) {
        if (session.isToolControlEnabled() && player.hasPermission("worldedit.selection.pos")) {
            WorldVector target = this.getTarget(player);
            if (target == null) {
                return true;
            }
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectSecondary(target)) {
                selector.explainSecondarySelection(player, session, target);
            }
            return true;
        }
        return false;
    }

    public WorldVector getTarget(LocalPlayer player) {
        WorldVector target = null;
        target = this.range > -1 ? player.getBlockTrace(this.getRange(), true) : player.getBlockTrace(MAX_RANGE);
        if (target == null) {
            player.printError("No block in sight!");
            return null;
        }
        return target;
    }
}

