/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.regions.Region;
import java.util.Random;

public abstract class LocalWorld {
    protected Random random = new Random();

    public abstract String getName();

    public abstract boolean setBlockType(Vector var1, int var2);

    public boolean setBlockTypeFast(Vector pt, int type) {
        return this.setBlockType(pt, type);
    }

    public abstract int getBlockType(Vector var1);

    public abstract void setBlockData(Vector var1, int var2);

    public abstract void setBlockDataFast(Vector var1, int var2);

    public boolean setTypeIdAndData(Vector pt, int type, int data) {
        boolean ret = this.setBlockType(pt, type);
        this.setBlockData(pt, data);
        return ret;
    }

    public boolean setTypeIdAndDataFast(Vector pt, int type, int data) {
        boolean ret = this.setBlockTypeFast(pt, type);
        this.setBlockDataFast(pt, data);
        return ret;
    }

    public abstract int getBlockData(Vector var1);

    public abstract int getBlockLightLevel(Vector var1);

    public abstract boolean regenerate(Region var1, EditSession var2);

    public abstract boolean copyToWorld(Vector var1, BaseBlock var2);

    public abstract boolean copyFromWorld(Vector var1, BaseBlock var2);

    public abstract boolean clearContainerBlockContents(Vector var1);

    public abstract boolean generateTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateBigTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateBirchTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateRedwoodTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public abstract boolean generateTallRedwoodTree(EditSession var1, Vector var2) throws MaxChangedBlocksException;

    public void dropItem(Vector pt, BaseItemStack item, int times) {
        for (int i = 0; i < times; ++i) {
            this.dropItem(pt, item);
        }
    }

    public abstract void dropItem(Vector var1, BaseItemStack var2);

    public void simulateBlockMine(Vector pt) {
        BaseItemStack stack = BlockType.getBlockDrop(this.getBlockType(pt), (short)this.getBlockData(pt));
        if (stack != null) {
            this.dropItem(pt, stack.getAmount() > 1 ? new BaseItemStack(stack.getType(), 1, stack.getDamage()) : stack, stack.getAmount());
        }
    }

    public abstract int killMobs(Vector var1, int var2);

    public abstract int killMobs(Vector var1, int var2, boolean var3);

    public abstract int removeEntities(EntityType var1, Vector var2, int var3);

    public boolean isValidBlockType(int type) {
        return BlockType.fromID(type) != null;
    }

    public abstract void checkLoadedChuck(Vector var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public int getHeight() {
        return 127;
    }
}

