/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.data.MissingWorldException;
import com.sk89q.worldedit.snapshots.InvalidSnapshotException;
import com.sk89q.worldedit.snapshots.Snapshot;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

public class SnapshotCommands {
    private static Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");

    @Command(aliases={"list"}, usage="[num]", desc="List snapshots", min=0, max=1)
    @CommandPermissions(value={"worldedit.snapshots.list"})
    public static void list(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (snapshots.size() > 0) {
                int num = args.argsLength() > 0 ? Math.min(40, Math.max(5, args.getInteger(0))) : 5;
                player.print("Snapshots for world: '" + player.getWorld().getName() + "'");
                for (int i = 0; i < Math.min(num, snapshots.size()); i = (int)((byte)(i + 1))) {
                    player.print(i + 1 + ". " + snapshots.get(i).getName());
                }
                player.print("Use /snap use [snapshot] or /snap use latest.");
            } else {
                player.printError("No snapshots are available. See console for details.");
                File dir = config.snapshotRepo.getDirectory();
                try {
                    logger.info("WorldEdit found no snapshots: looked in: " + dir.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                }
            }
        }
        catch (MissingWorldException ex) {
            player.printError("No snapshots were found for this world.");
        }
    }

    @Command(aliases={"use"}, usage="<snapshot>", desc="Choose a snapshot to use", min=1, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public static void use(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        block8: {
            LocalConfiguration config = we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("Snapshot/backup restore is not configured.");
                return;
            }
            String name = args.getString(0);
            if (name.equalsIgnoreCase("latest")) {
                try {
                    Snapshot snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) {
                        session.setSnapshot(null);
                        player.print("Now using newest snapshot.");
                        break block8;
                    }
                    player.printError("No snapshots were found.");
                }
                catch (MissingWorldException ex) {
                    player.printError("No snapshots were found for this world.");
                }
            } else {
                try {
                    session.setSnapshot(config.snapshotRepo.getSnapshot(name));
                    player.print("Snapshot set to: " + name);
                }
                catch (InvalidSnapshotException e) {
                    player.printError("That snapshot does not exist or is not available.");
                }
            }
        }
    }

    @Command(aliases={"before"}, usage="<date>", desc="Choose the nearest snapshot before a date", min=1, max=-1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public static void before(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        Calendar date = session.detectDate(args.getJoinedStrings(0));
        if (date == null) {
            player.printError("Could not detect the date inputted.");
        } else {
            try {
                Snapshot snapshot = config.snapshotRepo.getSnapshotBefore(date, player.getWorld().getName());
                if (snapshot == null) {
                    dateFormat.setTimeZone(session.getTimeZone());
                    player.printError("Couldn't find a snapshot before " + dateFormat.format(date.getTime()) + ".");
                } else {
                    session.setSnapshot(snapshot);
                    player.print("Snapshot set to: " + snapshot.getName());
                }
            }
            catch (MissingWorldException ex) {
                player.printError("No snapshots were found for this world.");
            }
        }
    }

    @Command(aliases={"after"}, usage="<date>", desc="Choose the nearest snapshot after a date", min=1, max=-1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public static void after(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("Snapshot/backup restore is not configured.");
            return;
        }
        Calendar date = session.detectDate(args.getJoinedStrings(0));
        if (date == null) {
            player.printError("Could not detect the date inputted.");
        } else {
            try {
                Snapshot snapshot = config.snapshotRepo.getSnapshotAfter(date, player.getWorld().getName());
                if (snapshot == null) {
                    dateFormat.setTimeZone(session.getTimeZone());
                    player.printError("Couldn't find a snapshot after " + dateFormat.format(date.getTime()) + ".");
                } else {
                    session.setSnapshot(snapshot);
                    player.print("Snapshot set to: " + snapshot.getName());
                }
            }
            catch (MissingWorldException ex) {
                player.printError("No snapshots were found for this world.");
            }
        }
    }
}

