/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.data;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.data.Chunk;
import com.sk89q.worldedit.data.DataException;
import java.io.IOException;

public abstract class ChunkStore {
    public static BlockVector2D toChunk(Vector pos) {
        int chunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
        int chunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
        return new BlockVector2D(chunkX, chunkZ);
    }

    public abstract CompoundTag getChunkTag(Vector2D var1, String var2) throws DataException, IOException;

    public Chunk getChunk(Vector2D pos, String world) throws DataException, IOException {
        return new Chunk(this.getChunkTag(pos, world));
    }

    public void close() throws IOException {
    }

    public abstract boolean isValid();
}

