/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.regions.Region;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuboidRegion
implements Region {
    private Vector pos1;
    private Vector pos2;

    public CuboidRegion(Vector pos1, Vector pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    @Override
    public Vector getMinimumPoint() {
        return new Vector(Math.min(this.pos1.getX(), this.pos2.getX()), Math.min(this.pos1.getY(), this.pos2.getY()), Math.min(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public Vector getMaximumPoint() {
        return new Vector(Math.max(this.pos1.getX(), this.pos2.getX()), Math.max(this.pos1.getY(), this.pos2.getY()), Math.max(this.pos1.getZ(), this.pos2.getZ()));
    }

    @Override
    public int getArea() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)((max.getX() - min.getX() + 1.0) * (max.getY() - min.getY() + 1.0) * (max.getZ() - min.getZ() + 1.0));
    }

    @Override
    public int getWidth() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getX() - min.getX() + 1.0);
    }

    @Override
    public int getHeight() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getY() - min.getY() + 1.0);
    }

    @Override
    public int getLength() {
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return (int)(max.getZ() - min.getZ() + 1.0);
    }

    @Override
    public void expand(Vector change) {
        if (change.getX() > 0.0) {
            if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
        } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
            this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
        } else {
            this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
        }
        if (change.getY() > 0.0) {
            if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
        } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
            this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
        } else {
            this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
        }
        if (change.getZ() > 0.0) {
            if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
            }
        } else if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
            this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
        } else {
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.pos1 = this.pos1.clampY(0, 127);
        this.pos2 = this.pos2.clampY(0, 127);
    }

    @Override
    public void contract(Vector change) {
        if (change.getX() < 0.0) {
            if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
            }
        } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
            this.pos1 = this.pos1.add(new Vector(change.getX(), 0.0, 0.0));
        } else {
            this.pos2 = this.pos2.add(new Vector(change.getX(), 0.0, 0.0));
        }
        if (change.getY() < 0.0) {
            if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
            }
        } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
            this.pos1 = this.pos1.add(new Vector(0.0, change.getY(), 0.0));
        } else {
            this.pos2 = this.pos2.add(new Vector(0.0, change.getY(), 0.0));
        }
        if (change.getZ() < 0.0) {
            if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
            } else {
                this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
            }
        } else if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
            this.pos1 = this.pos1.add(new Vector(0.0, 0.0, change.getZ()));
        } else {
            this.pos2 = this.pos2.add(new Vector(0.0, 0.0, change.getZ()));
        }
        this.pos1 = this.pos1.clampY(0, 127);
        this.pos2 = this.pos2.clampY(0, 127);
    }

    public Vector getPos1() {
        return this.pos1;
    }

    public void setPos1(Vector pos1) {
        this.pos1 = pos1;
    }

    public Vector getPos2() {
        return this.pos2;
    }

    public void setPos2(Vector pos2) {
        this.pos2 = pos2;
    }

    @Override
    public Set<Vector2D> getChunks() {
        HashSet<Vector2D> chunks = new HashSet<Vector2D>();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int y = min.getBlockY(); y <= max.getBlockY(); ++y) {
                for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                    Vector pt = new Vector(x, y, z);
                    chunks.add(ChunkStore.toChunk(pt));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(Vector pt) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        Vector min = this.getMinimumPoint();
        Vector max = this.getMaximumPoint();
        return x >= (double)min.getBlockX() && x <= (double)max.getBlockX() && y >= (double)min.getBlockY() && y <= (double)max.getBlockY() && z >= (double)min.getBlockZ() && z <= (double)max.getBlockZ();
    }

    @Override
    public Iterator<BlockVector> iterator() {
        return new Iterator<BlockVector>(){
            private Vector min;
            private Vector max;
            private int nextX;
            private int nextY;
            private int nextZ;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextY = this.min.getBlockY();
                this.nextZ = this.min.getBlockZ();
            }

            @Override
            public boolean hasNext() {
                return this.nextX != Integer.MIN_VALUE;
            }

            @Override
            public BlockVector next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockVector answer = new BlockVector(this.nextX, this.nextY, this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextY > this.max.getBlockY()) {
                        this.nextY = this.min.getBlockY();
                        if (++this.nextZ > this.max.getBlockZ()) {
                            this.nextX = Integer.MIN_VALUE;
                        }
                    }
                }
                return answer;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.getMinimumPoint() + " - " + this.getMaximumPoint();
    }
}

