/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.cache;

import com.lishid.orebfuscator.Orebfuscator;
import com.lishid.orebfuscator.OrebfuscatorConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import net.minecraft.server.RegionFile;

public class ObfuscatedDataCache {
    private static final HashMap<File, Reference<RegionFile>> cachedRegionFiles = new HashMap();

    public static synchronized RegionFile getRegionFile(File folder, int x, int z) {
        File path = new File(folder, "region");
        File file = new File(path, "r." + (x >> 5) + "." + (z >> 5) + ".mcr");
        try {
            RegionFile regionFile;
            Reference<RegionFile> reference = cachedRegionFiles.get(file);
            if (reference != null && (regionFile = reference.get()) != null) {
                return regionFile;
            }
            if (!path.exists()) {
                path.mkdirs();
            }
            if (cachedRegionFiles.size() >= OrebfuscatorConfig.getMaxLoadedCacheFiles()) {
                ObfuscatedDataCache.clearCache();
            }
            regionFile = new RegionFile(file);
            cachedRegionFiles.put(file, new SoftReference<RegionFile>(regionFile));
            return regionFile;
        }
        catch (Exception e) {
            try {
                file.delete();
            }
            catch (Exception e2) {
                Orebfuscator.log(e);
            }
            return null;
        }
    }

    public static synchronized void clearCache() {
        for (Reference<RegionFile> reference : cachedRegionFiles.values()) {
            try {
                RegionFile regionFile = reference.get();
                if (regionFile == null) continue;
                regionFile.c();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cachedRegionFiles.clear();
    }

    public static DataInputStream getInputStream(File folder, int x, int z) {
        RegionFile regionFile = ObfuscatedDataCache.getRegionFile(folder, x, z);
        return regionFile.a(x & 0x1F, z & 0x1F);
    }

    public static DataOutputStream getOutputStream(File folder, int x, int z) {
        RegionFile regionFile = ObfuscatedDataCache.getRegionFile(folder, x, z);
        return regionFile.b(x & 0x1F, z & 0x1F);
    }

    public static void ClearCache() {
        ObfuscatedDataCache.clearCache();
        try {
            ObfuscatedDataCache.DeleteDir(OrebfuscatorConfig.getCacheFolder());
        }
        catch (Exception e) {
            Orebfuscator.log(e);
        }
    }

    private static void DeleteDir(File dir) {
        try {
            if (!dir.exists()) {
                return;
            }
            if (dir.isDirectory()) {
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    ObfuscatedDataCache.DeleteDir(f);
                    ++n2;
                }
            }
            dir.delete();
        }
        catch (Exception e) {
            Orebfuscator.log(e);
        }
    }
}

