/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.hithack;

import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.hithack.PlayerBlockTracking;
import java.util.HashMap;
import org.bukkit.GameMode;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockHitManager {
    private static HashMap<Player, PlayerBlockTracking> playersBlockTrackingStatus = new HashMap();

    public static boolean hitBlock(Player player, Block block) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return true;
        }
        PlayerBlockTracking playerBlockTracking = BlockHitManager.getPlayerBlockTracking(player);
        if (playerBlockTracking.isBlock(block)) {
            return true;
        }
        long time = playerBlockTracking.getTimeDifference();
        playerBlockTracking.incrementHackingIndicator();
        playerBlockTracking.setBlock(block);
        playerBlockTracking.updateTime();
        int decrement = (int)(time / (long)OrebfuscatorConfig.getAntiHitHackDecrementFactor());
        playerBlockTracking.decrementHackingIndicator(decrement);
        if (playerBlockTracking.getHackingIndicator() == OrebfuscatorConfig.getAntiHitHackMaxViolation()) {
            playerBlockTracking.incrementHackingIndicator(OrebfuscatorConfig.getAntiHitHackMaxViolation());
        }
        return playerBlockTracking.getHackingIndicator() <= OrebfuscatorConfig.getAntiHitHackMaxViolation();
    }

    public static boolean canFakeHit(Player player) {
        PlayerBlockTracking playerBlockTracking = BlockHitManager.getPlayerBlockTracking(player);
        return playerBlockTracking.getHackingIndicator() <= OrebfuscatorConfig.getAntiHitHackMaxViolation();
    }

    public static boolean fakeHit(Player player) {
        PlayerBlockTracking playerBlockTracking = BlockHitManager.getPlayerBlockTracking(player);
        playerBlockTracking.incrementHackingIndicator();
        return playerBlockTracking.getHackingIndicator() <= OrebfuscatorConfig.getAntiHitHackMaxViolation();
    }

    public static void breakBlock(Player player, Block block) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        PlayerBlockTracking playerBlockTracking = BlockHitManager.getPlayerBlockTracking(player);
        if (playerBlockTracking.isBlock(block)) {
            playerBlockTracking.decrementHackingIndicator(2);
        }
    }

    private static PlayerBlockTracking getPlayerBlockTracking(Player player) {
        if (!playersBlockTrackingStatus.containsKey(player)) {
            playersBlockTrackingStatus.put(player, new PlayerBlockTracking(player));
        }
        return playersBlockTrackingStatus.get(player);
    }

    public static void clearHistory(Player player) {
        playersBlockTrackingStatus.remove(player);
    }

    public static void clearAll() {
        playersBlockTrackingStatus.clear();
    }
}

