/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.obfuscation;

import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.obfuscation.CalculationsUtil;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.WorldServer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.CraftWorld;

public class BlockUpdate {
    public static boolean needsUpdate(Block block) {
        return !OrebfuscatorConfig.isBlockTransparent((short)block.getTypeId());
    }

    public static void Update(Block block) {
        if (!BlockUpdate.needsUpdate(block)) {
            return;
        }
        HashSet<Block> updateBlocks = BlockUpdate.GetAjacentBlocks(block.getWorld(), new HashSet<Block>(), block, OrebfuscatorConfig.getUpdateRadius());
        WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
        updateBlocks.remove(block);
        for (Block nearbyBlock : updateBlocks) {
            worldServer.notify(nearbyBlock.getX(), nearbyBlock.getY(), nearbyBlock.getZ());
        }
    }

    public static void Update(List<Block> blocks) {
        if (blocks.size() <= 0) {
            return;
        }
        HashSet<Block> updateBlocks = new HashSet<Block>();
        for (Block block : blocks) {
            if (!BlockUpdate.needsUpdate(block)) continue;
            updateBlocks.addAll(BlockUpdate.GetAjacentBlocks(block.getWorld(), new HashSet<Block>(), block, OrebfuscatorConfig.getUpdateRadius()));
        }
        WorldServer worldServer = ((CraftWorld)blocks.get(0).getWorld()).getHandle();
        for (Block nearbyBlock : updateBlocks) {
            worldServer.notify(nearbyBlock.getX(), nearbyBlock.getY(), nearbyBlock.getZ());
        }
    }

    public static HashSet<Block> GetAjacentBlocks(World world, HashSet<Block> allBlocks, Block block, int countdown) {
        if (block == null) {
            return allBlocks;
        }
        BlockUpdate.AddBlockCheck(allBlocks, block);
        if (countdown == 0) {
            return allBlocks;
        }
        BlockUpdate.GetAjacentBlocks(world, allBlocks, CalculationsUtil.getBlockAt(world, block.getX() + 1, block.getY(), block.getZ()), countdown - 1);
        BlockUpdate.GetAjacentBlocks(world, allBlocks, CalculationsUtil.getBlockAt(world, block.getX() - 1, block.getY(), block.getZ()), countdown - 1);
        BlockUpdate.GetAjacentBlocks(world, allBlocks, CalculationsUtil.getBlockAt(world, block.getX(), block.getY() + 1, block.getZ()), countdown - 1);
        BlockUpdate.GetAjacentBlocks(world, allBlocks, CalculationsUtil.getBlockAt(world, block.getX(), block.getY() - 1, block.getZ()), countdown - 1);
        BlockUpdate.GetAjacentBlocks(world, allBlocks, CalculationsUtil.getBlockAt(world, block.getX(), block.getY(), block.getZ() + 1), countdown - 1);
        BlockUpdate.GetAjacentBlocks(world, allBlocks, CalculationsUtil.getBlockAt(world, block.getX(), block.getY(), block.getZ() - 1), countdown - 1);
        return allBlocks;
    }

    public static void AddBlockCheck(HashSet<Block> allBlocks, Block block) {
        if (OrebfuscatorConfig.isObfuscated((byte)block.getTypeId()) || OrebfuscatorConfig.isDarknessObfuscated((byte)block.getTypeId())) {
            allBlocks.add(block);
        }
    }
}

