/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator;

import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.cache.ObfuscatedDataCache;
import com.lishid.orebfuscator.commands.OrebfuscatorCommandExecutor;
import com.lishid.orebfuscator.hithack.BlockHitManager;
import com.lishid.orebfuscator.hook.ChunkProcessingThread;
import com.lishid.orebfuscator.hook.OrebfuscatorPlayerHook;
import com.lishid.orebfuscator.hook.ProtocolLibHook;
import com.lishid.orebfuscator.listeners.OrebfuscatorBlockListener;
import com.lishid.orebfuscator.listeners.OrebfuscatorEntityListener;
import com.lishid.orebfuscator.listeners.OrebfuscatorPlayerListener;
import com.lishid.orebfuscator.proximityhider.ProximityHider;
import com.lishid.orebfuscator.utils.Metrics;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Orebfuscator
extends JavaPlugin {
    private static Metrics metrics;
    public static final Logger logger;
    public static Orebfuscator instance;
    public static boolean usePL;

    static {
        logger = Logger.getLogger("Minecraft.OFC");
        usePL = false;
    }

    public void onEnable() {
        instance = this;
        PluginManager pm = this.getServer().getPluginManager();
        OrebfuscatorConfig.load();
        pm.registerEvents((Listener)new OrebfuscatorPlayerListener(), (Plugin)this);
        pm.registerEvents((Listener)new OrebfuscatorEntityListener(), (Plugin)this);
        pm.registerEvents((Listener)new OrebfuscatorBlockListener(), (Plugin)this);
        pm.registerEvents((Listener)new OrebfuscatorPlayerHook(), (Plugin)this);
        if (pm.getPlugin("ProtocolLib") != null) {
            Orebfuscator.log("ProtocolLib found! Hooking into ProtocolLib.");
            new ProtocolLibHook().register((Plugin)this);
            usePL = true;
        }
        try {
            metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception e) {
            Orebfuscator.log(e);
        }
    }

    public void onDisable() {
        ObfuscatedDataCache.clearCache();
        ProximityHider.terminate();
        ProximityHider.proximityHiderTracker.clear();
        ProximityHider.playersToCheck.clear();
        BlockHitManager.clearAll();
        ChunkProcessingThread.KillAll();
        instance.getServer().getScheduler().cancelAllTasks();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return OrebfuscatorCommandExecutor.onCommand(sender, command, label, args);
    }

    public static void log(String text) {
        logger.info(ChatColor.AQUA + "[OFC] " + text);
    }

    public static void log(Throwable e) {
        logger.severe("[OFC] " + e.toString());
        e.printStackTrace();
    }

    public static void message(CommandSender target, String message) {
        target.sendMessage(ChatColor.AQUA + "[OFC] " + message);
    }
}

