/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator;

import com.lishid.orebfuscator.Orebfuscator;
import com.lishid.orebfuscator.cache.ObfuscatedDataCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.server.Block;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class OrebfuscatorConfig {
    private static Random random = new Random();
    private static final int CONFIG_VERSION = 9;
    private static boolean[] ObfuscateBlocks = new boolean[256];
    private static boolean[] ProximityHiderBlocks = new boolean[256];
    private static Integer[] RandomBlocks = new Integer[]{1, 4, 5, 14, 15, 16, 21, 46, 48, 49, 56, 73, 82, 129};
    private static Integer[] RandomBlocks2 = RandomBlocks;
    private static List<String> DisabledWorlds = new ArrayList<String>();
    private static int EngineMode = 2;
    private static int UpdateRadius = 2;
    private static int InitialRadius = 1;
    private static int ProcessingThreads = Runtime.getRuntime().availableProcessors() - 1;
    private static int MaxLoadedCacheFiles = 64;
    private static int ProximityHiderDistance = 8;
    private static int ProximityHiderID = 1;
    private static int ProximityHiderEnd = 255;
    private static int AirGeneratorMaxChance = 43;
    private static int OrebfuscatorPriority = 0;
    private static boolean UseProximityHider = true;
    private static boolean UseSpecialBlockForProximityHider = true;
    private static boolean UpdateOnDamage = true;
    private static boolean DarknessHideBlocks = true;
    private static boolean NoObfuscationForOps = false;
    private static boolean NoObfuscationForPermission = false;
    private static boolean LoginNotification = true;
    private static boolean AntiTexturePackAndFreecam = true;
    private static boolean UseCache = true;
    private static boolean Enabled = true;
    private static boolean LiteMode = false;
    private static String CacheLocation = "orebfuscator_cache";
    private static File CacheFolder = new File(Bukkit.getServer().getWorldContainer(), CacheLocation);
    private static int AntiHitHackDecrementFactor = 1000;
    private static int AntiHitHackMaxViolation = 15;
    private static int OverflowPacketCheckRate = 500;
    private static int ProximityHiderRate = 500;

    public static File getCacheFolder() {
        if (!CacheFolder.exists()) {
            CacheFolder.mkdirs();
        }
        if (!CacheFolder.exists()) {
            CacheFolder = new File("orebfuscator_cache");
        }
        return CacheFolder;
    }

    public static int getEngineMode() {
        return EngineMode;
    }

    public static int getUpdateRadius() {
        if (UpdateRadius < 0) {
            return 0;
        }
        return UpdateRadius;
    }

    public static int getInitialRadius() {
        if (InitialRadius < 0) {
            return 0;
        }
        return InitialRadius;
    }

    public static int getProcessingThreads() {
        if (ProcessingThreads <= 0) {
            return 1;
        }
        if (ProcessingThreads > Runtime.getRuntime().availableProcessors()) {
            return Runtime.getRuntime().availableProcessors();
        }
        return ProcessingThreads;
    }

    public static int getMaxLoadedCacheFiles() {
        if (MaxLoadedCacheFiles <= 16) {
            return 16;
        }
        if (MaxLoadedCacheFiles > 128) {
            return 128;
        }
        return MaxLoadedCacheFiles;
    }

    public static int getProximityHiderDistance() {
        if (ProximityHiderDistance <= 2) {
            return 2;
        }
        if (ProximityHiderDistance > 32) {
            return 32;
        }
        return ProximityHiderDistance;
    }

    public static int getProximityHiderID() {
        return ProximityHiderID;
    }

    public static int getProximityHiderEnd() {
        return ProximityHiderEnd;
    }

    public static int getAirGeneratorMaxChance() {
        if (AirGeneratorMaxChance < 40) {
            return 41;
        }
        if (AirGeneratorMaxChance > 100) {
            return 101;
        }
        return AirGeneratorMaxChance + 1;
    }

    public static int getOrebfuscatorPriority() {
        if (OrebfuscatorPriority < 0) {
            return 0;
        }
        if (OrebfuscatorPriority > 2) {
            return 2;
        }
        return OrebfuscatorPriority;
    }

    public static int getAntiHitHackDecrementFactor() {
        if (AntiHitHackDecrementFactor < 200) {
            return 200;
        }
        if (AntiHitHackDecrementFactor > 60000) {
            return 60000;
        }
        return AntiHitHackDecrementFactor;
    }

    public static int getAntiHitHackMaxViolation() {
        if (AntiHitHackMaxViolation < 3) {
            return 3;
        }
        if (AntiHitHackMaxViolation > 50) {
            return 50;
        }
        return AntiHitHackMaxViolation;
    }

    public static int getOverflowPacketCheckRate() {
        if (OverflowPacketCheckRate < 20) {
            return 20;
        }
        if (OverflowPacketCheckRate > 2000) {
            return 2000;
        }
        return OverflowPacketCheckRate;
    }

    public static int getProximityHiderRate() {
        if (ProximityHiderRate < 20) {
            return 20;
        }
        if (ProximityHiderRate > 2000) {
            return 2000;
        }
        return ProximityHiderRate;
    }

    public static boolean getUseProximityHider() {
        if (LiteMode) {
            return false;
        }
        return UseProximityHider;
    }

    public static boolean getUseSpecialBlockForProximityHider() {
        return UseSpecialBlockForProximityHider;
    }

    public static boolean getUpdateOnDamage() {
        return UpdateOnDamage;
    }

    public static boolean getDarknessHideBlocks() {
        return DarknessHideBlocks;
    }

    public static boolean getNoObfuscationForOps() {
        return NoObfuscationForOps;
    }

    public static boolean getNoObfuscationForPermission() {
        return NoObfuscationForPermission;
    }

    public static boolean getLoginNotification() {
        return LoginNotification;
    }

    public static boolean getAntiTexturePackAndFreecam() {
        if (LiteMode) {
            return false;
        }
        return AntiTexturePackAndFreecam;
    }

    public static boolean getUseCache() {
        return UseCache;
    }

    public static boolean getEnabled() {
        return Enabled;
    }

    public static boolean getLiteMode() {
        return LiteMode;
    }

    public static String getCacheLocation() {
        return CacheLocation;
    }

    public static boolean isBlockTransparent(short id) {
        if (id < 0) {
            id = (short)(id + 256);
        }
        return !Block.i((int)id);
    }

    public static boolean isObfuscated(short id) {
        if (id < 0) {
            id = (short)(id + 256);
        }
        if (id == 1) {
            return true;
        }
        return ObfuscateBlocks[id];
    }

    public static boolean isDarknessObfuscated(byte id) {
        return id == 52 || id == 54;
    }

    public static boolean isProximityObfuscated(short id) {
        if (id < 0) {
            id = (short)(id + 256);
        }
        return ProximityHiderBlocks[id];
    }

    public static boolean isWorldDisabled(String name) {
        for (String world : DisabledWorlds) {
            if (!world.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static String getDisabledWorlds() {
        String retval = "";
        for (String world : DisabledWorlds) {
            retval = String.valueOf(retval) + world + ", ";
        }
        return retval.length() > 1 ? retval.substring(0, retval.length() - 2) : retval;
    }

    public static byte getRandomBlock(int index, boolean alternate) {
        return (byte)(alternate ? RandomBlocks2[index] : RandomBlocks[index]).intValue();
    }

    public static Integer[] getRandomBlocks(boolean alternate) {
        return alternate ? RandomBlocks2 : RandomBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffleRandomBlocks() {
        Integer[] integerArray = RandomBlocks;
        synchronized (RandomBlocks) {
            Collections.shuffle(Arrays.asList(RandomBlocks));
            Collections.shuffle(Arrays.asList(RandomBlocks2));
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static int random(int max) {
        return random.nextInt(max);
    }

    public static void setEngineMode(int data) {
        OrebfuscatorConfig.setData("Integers.EngineMode", data);
        EngineMode = data;
    }

    public static void setUpdateRadius(int data) {
        OrebfuscatorConfig.setData("Integers.UpdateRadius", data);
        UpdateRadius = data;
    }

    public static void setInitialRadius(int data) {
        OrebfuscatorConfig.setData("Integers.InitialRadius", data);
        InitialRadius = data;
    }

    public static void setProcessingThreads(int data) {
        OrebfuscatorConfig.setData("Integers.ProcessingThreads", data);
        ProcessingThreads = data;
    }

    public static void setMaxLoadedCacheFiles(int data) {
        OrebfuscatorConfig.setData("Integers.MaxLoadedCacheFiles", data);
        MaxLoadedCacheFiles = data;
    }

    public static void setProximityHiderDistance(int data) {
        OrebfuscatorConfig.setData("Integers.ProximityHiderDistance", data);
        ProximityHiderDistance = data;
    }

    public static void setProximityHiderID(int data) {
        OrebfuscatorConfig.setData("Integers.ProximityHiderID", data);
        ProximityHiderID = data;
    }

    public static void setProximityHiderEnd(int data) {
        OrebfuscatorConfig.setData("Integers.ProximityHiderEnd", data);
        ProximityHiderEnd = data;
    }

    public static void setAirGeneratorMaxChance(int data) {
        OrebfuscatorConfig.setData("Integers.AirGeneratorMaxChance", data);
        AirGeneratorMaxChance = data;
    }

    public static void setOrebfuscatorPriority(int data) {
        OrebfuscatorConfig.setData("Integers.OrebfuscatorPriority", data);
        OrebfuscatorPriority = data;
    }

    public static void setUseProximityHider(boolean data) {
        OrebfuscatorConfig.setData("Booleans.UseProximityHider", data);
        UseProximityHider = data;
    }

    public static void setUseSpecialBlockForProximityHider(boolean data) {
        OrebfuscatorConfig.setData("Booleans.UseSpecialBlockForProximityHider", data);
        UseSpecialBlockForProximityHider = data;
    }

    public static void setUpdateOnDamage(boolean data) {
        OrebfuscatorConfig.setData("Booleans.UpdateOnDamage", data);
        UpdateOnDamage = data;
    }

    public static void setDarknessHideBlocks(boolean data) {
        OrebfuscatorConfig.setData("Booleans.DarknessHideBlocks", data);
        DarknessHideBlocks = data;
    }

    public static void setNoObfuscationForOps(boolean data) {
        OrebfuscatorConfig.setData("Booleans.NoObfuscationForOps", data);
        NoObfuscationForOps = data;
    }

    public static void setNoObfuscationForPermission(boolean data) {
        OrebfuscatorConfig.setData("Booleans.NoObfuscationForPermission", data);
        NoObfuscationForPermission = data;
    }

    public static void setLoginNotification(boolean data) {
        OrebfuscatorConfig.setData("Booleans.LoginNotification", data);
        LoginNotification = data;
    }

    public static void setAntiTexturePackAndFreecam(boolean data) {
        OrebfuscatorConfig.setData("Booleans.AntiTexturePackAndFreecam", data);
        AntiTexturePackAndFreecam = data;
    }

    public static void setUseCache(boolean data) {
        OrebfuscatorConfig.setData("Booleans.UseCache", data);
        UseCache = data;
    }

    public static void setEnabled(boolean data) {
        OrebfuscatorConfig.setData("Booleans.Enabled", data);
        Enabled = data;
    }

    public static void setLiteMode(boolean data) {
        OrebfuscatorConfig.setData("Booleans.LiteMode", data);
        LiteMode = data;
    }

    public static void setCacheLocation(String data) {
        OrebfuscatorConfig.setData("Strings.CacheLocation", data);
        CacheFolder = new File(data);
        CacheLocation = data;
    }

    public static void setDisabledWorlds(String name, boolean data) {
        if (!data) {
            DisabledWorlds.remove(name);
        } else {
            DisabledWorlds.add(name);
        }
        OrebfuscatorConfig.setData("Lists.DisabledWorlds", DisabledWorlds);
    }

    private static boolean getBoolean(String path, boolean defaultData) {
        if (Orebfuscator.instance.getConfig().get(path) == null) {
            OrebfuscatorConfig.setData(path, defaultData);
        }
        return Orebfuscator.instance.getConfig().getBoolean(path, defaultData);
    }

    private static String getString(String path, String defaultData) {
        if (Orebfuscator.instance.getConfig().get(path) == null) {
            OrebfuscatorConfig.setData(path, defaultData);
        }
        return Orebfuscator.instance.getConfig().getString(path, defaultData);
    }

    private static int getInt(String path, int defaultData) {
        if (Orebfuscator.instance.getConfig().get(path) == null) {
            OrebfuscatorConfig.setData(path, defaultData);
        }
        return Orebfuscator.instance.getConfig().getInt(path, defaultData);
    }

    private static List<Integer> getIntList(String path, List<Integer> defaultData) {
        if (Orebfuscator.instance.getConfig().get(path) == null) {
            OrebfuscatorConfig.setData(path, defaultData);
        }
        return Orebfuscator.instance.getConfig().getIntegerList(path);
    }

    private static Integer[] getIntList2(String path, List<Integer> defaultData) {
        if (Orebfuscator.instance.getConfig().get(path) == null) {
            OrebfuscatorConfig.setData(path, defaultData);
        }
        return Orebfuscator.instance.getConfig().getIntegerList(path).toArray(new Integer[1]);
    }

    private static List<String> getStringList(String path, List<String> defaultData) {
        if (Orebfuscator.instance.getConfig().get(path) == null) {
            OrebfuscatorConfig.setData(path, defaultData);
        }
        return Orebfuscator.instance.getConfig().getStringList(path);
    }

    private static void setData(String path, Object data) {
        try {
            Orebfuscator.instance.getConfig().set(path, data);
            OrebfuscatorConfig.save();
        }
        catch (Exception e) {
            Orebfuscator.log(e);
        }
    }

    private static void setBlockValues(boolean[] boolArray, List<Integer> blocks, boolean removeTransparent) {
        int i = 0;
        while (i < boolArray.length) {
            boolArray[i] = blocks.contains(i);
            if (removeTransparent && boolArray[i] && OrebfuscatorConfig.isBlockTransparent((short)i)) {
                boolArray[i] = false;
            }
            ++i;
        }
    }

    public static void load() {
        int version = OrebfuscatorConfig.getInt("ConfigVersion", 9);
        if (version < 9) {
            ObfuscatedDataCache.ClearCache();
            OrebfuscatorConfig.setData("ConfigVersion", 9);
        }
        if ((EngineMode = OrebfuscatorConfig.getInt("Integers.EngineMode", EngineMode)) != 1 && EngineMode != 2) {
            EngineMode = 2;
            System.out.println("[Orebfuscator] EngineMode must be 1 or 2.");
        }
        UpdateRadius = OrebfuscatorConfig.getInt("Integers.UpdateRadius", UpdateRadius);
        if ((InitialRadius = OrebfuscatorConfig.getInt("Integers.InitialRadius", InitialRadius)) > 5) {
            InitialRadius = 5;
            System.out.println("[Orebfuscator] InitialRadius must be less than 6.");
        }
        if (InitialRadius == 0) {
            System.out.println("[Orebfuscator] Warning, InitialRadius is 0. This will cause all exposed blocks to be obfuscated.");
        }
        ProcessingThreads = OrebfuscatorConfig.getInt("Integers.ProcessingThreads", ProcessingThreads);
        MaxLoadedCacheFiles = OrebfuscatorConfig.getInt("Integers.MaxLoadedCacheFiles", MaxLoadedCacheFiles);
        ProximityHiderDistance = OrebfuscatorConfig.getInt("Integers.ProximityHiderDistance", ProximityHiderDistance);
        ProximityHiderID = OrebfuscatorConfig.getInt("Integers.ProximityHiderID", ProximityHiderID);
        ProximityHiderEnd = OrebfuscatorConfig.getInt("Integers.ProximityHiderEnd", ProximityHiderEnd);
        AirGeneratorMaxChance = OrebfuscatorConfig.getInt("Integers.AirGeneratorMaxChance", AirGeneratorMaxChance);
        OrebfuscatorPriority = OrebfuscatorConfig.getInt("Integers.OrebfuscatorPriority", OrebfuscatorPriority);
        UseProximityHider = OrebfuscatorConfig.getBoolean("Booleans.UseProximityHider", UseProximityHider);
        UseSpecialBlockForProximityHider = OrebfuscatorConfig.getBoolean("Booleans.UseSpecialBlockForProximityHider", UseSpecialBlockForProximityHider);
        UpdateOnDamage = OrebfuscatorConfig.getBoolean("Booleans.UpdateOnDamage", UpdateOnDamage);
        DarknessHideBlocks = OrebfuscatorConfig.getBoolean("Booleans.DarknessHideBlocks", DarknessHideBlocks);
        NoObfuscationForOps = OrebfuscatorConfig.getBoolean("Booleans.NoObfuscationForOps", NoObfuscationForOps);
        NoObfuscationForPermission = OrebfuscatorConfig.getBoolean("Booleans.NoObfuscationForPermission", NoObfuscationForPermission);
        UseCache = OrebfuscatorConfig.getBoolean("Booleans.UseCache", UseCache);
        LoginNotification = OrebfuscatorConfig.getBoolean("Booleans.LoginNotification", LoginNotification);
        AntiTexturePackAndFreecam = OrebfuscatorConfig.getBoolean("Booleans.AntiTexturePackAndFreecam", AntiTexturePackAndFreecam);
        Enabled = OrebfuscatorConfig.getBoolean("Booleans.Enabled", Enabled);
        LiteMode = OrebfuscatorConfig.getBoolean("Booleans.LiteMode", LiteMode);
        OrebfuscatorConfig.setBlockValues(ObfuscateBlocks, OrebfuscatorConfig.getIntList("Lists.ObfuscateBlocks", Arrays.asList(14, 15, 16, 21, 54, 56, 73, 74, 129, 130)), true);
        OrebfuscatorConfig.setBlockValues(ProximityHiderBlocks, OrebfuscatorConfig.getIntList("Lists.ProximityHiderBlocks", Arrays.asList(23, 54, 56, 58, 61, 62, 116, 129, 130, 145)), false);
        DisabledWorlds = OrebfuscatorConfig.getStringList("Lists.DisabledWorlds", DisabledWorlds);
        CacheLocation = OrebfuscatorConfig.getString("Strings.CacheLocation", CacheLocation);
        CacheFolder = new File(CacheLocation);
        RandomBlocks = OrebfuscatorConfig.getIntList2("Lists.RandomBlocks", Arrays.asList(RandomBlocks));
        int i = 0;
        while (i < RandomBlocks.length) {
            if (OrebfuscatorConfig.isBlockTransparent((short)RandomBlocks[i].intValue())) {
                OrebfuscatorConfig.RandomBlocks[i] = 1;
            }
            ++i;
        }
        RandomBlocks2 = RandomBlocks;
        OrebfuscatorConfig.save();
    }

    public static void reload() {
        Orebfuscator.instance.reloadConfig();
        OrebfuscatorConfig.load();
    }

    public static void save() {
        Orebfuscator.instance.saveConfig();
    }

    public static boolean obfuscateForPlayer(Player player) {
        return !OrebfuscatorConfig.playerBypassOp(player) && !OrebfuscatorConfig.playerBypassPerms(player);
    }

    public static boolean playerBypassOp(Player player) {
        boolean ret = false;
        try {
            ret = OrebfuscatorConfig.getNoObfuscationForOps() && player.isOp();
        }
        catch (Exception e) {
            Orebfuscator.log("Error while obtaining Operator status for player" + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean playerBypassPerms(Player player) {
        boolean ret = false;
        try {
            ret = OrebfuscatorConfig.getNoObfuscationForPermission() && player.hasPermission("Orebfuscator.deobfuscate");
        }
        catch (Exception e) {
            Orebfuscator.log("Error while obtaining permissions for player" + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        return ret;
    }
}

