/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.cache;

import com.lishid.orebfuscator.cache.ObfuscatedDataCache;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import net.minecraft.server.NBTCompressedStreamTools;
import net.minecraft.server.NBTTagCompound;

public class ObfuscatedCachedChunk {
    File path;
    int x;
    int z;
    public int initialRadius;
    public boolean proximityHider;
    public byte[] data;
    public int[] proximityBlockList;
    public long hash = 0L;
    private boolean loaded = false;

    public ObfuscatedCachedChunk(File file, int x, int z, int initialRadius, boolean proximityHider) {
        this.x = x;
        this.z = z;
        this.initialRadius = initialRadius;
        this.proximityHider = proximityHider;
        this.path = new File(file, "data");
        this.path.mkdirs();
    }

    public void Invalidate() {
        this.Write(0L, new byte[0], new int[0]);
    }

    public void free() {
        this.data = null;
        this.proximityBlockList = null;
    }

    public long getHash() {
        this.Read();
        if (!this.loaded) {
            return 0L;
        }
        return this.hash;
    }

    public void Read() {
        if (this.loaded) {
            return;
        }
        try {
            DataInputStream stream = ObfuscatedDataCache.getInputStream(this.path, this.x, this.z);
            if (stream != null) {
                NBTTagCompound nbt = NBTCompressedStreamTools.a((DataInput)stream);
                if (nbt.getInt("X") != this.x || nbt.getInt("Z") != this.z || this.initialRadius != nbt.getInt("IR") || this.proximityHider != nbt.getBoolean("PH")) {
                    return;
                }
                this.hash = nbt.getLong("Hash");
                this.data = nbt.getByteArray("Data");
                this.proximityBlockList = this.proximityHider ? nbt.getIntArray("ProximityBlockList") : new int[0];
                this.loaded = true;
            }
        }
        catch (Exception e) {
            this.loaded = false;
        }
    }

    public void Write(long hash, byte[] data, int[] proximityBlockList) {
        try {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.setInt("X", this.x);
            nbt.setInt("Z", this.z);
            nbt.setInt("IR", this.initialRadius);
            nbt.setBoolean("PH", this.proximityHider);
            nbt.setLong("Hash", hash);
            nbt.setByteArray("Data", data);
            nbt.setIntArray("ProximityBlockList", proximityBlockList);
            DataOutputStream stream = ObfuscatedDataCache.getOutputStream(this.path, this.x, this.z);
            NBTCompressedStreamTools.a((NBTTagCompound)nbt, (DataOutput)stream);
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

