/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.commands;

import com.lishid.orebfuscator.Orebfuscator;
import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.cache.ObfuscatedDataCache;
import net.minecraft.server.ChunkCoordIntPair;
import org.bukkit.Chunk;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class OrebfuscatorCommandExecutor {
    public static boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("rechunk") && sender instanceof Player) {
            int r = 2;
            if (args.length > 0) {
                try {
                    r = new Integer(args[0]);
                }
                catch (NumberFormatException e) {
                    Orebfuscator.message(sender, String.valueOf(args[0]) + " is not a number!");
                    return true;
                }
                if (r < 1) {
                    r = 1;
                }
                if (r > 10) {
                    r = 10;
                }
            }
            Player player = (Player)sender;
            Chunk chunk = player.getWorld().getChunkAt(player.getLocation());
            int x = chunk.getX();
            int z = chunk.getZ();
            int i = x - r;
            while (i <= x + r) {
                int j = z - r;
                while (j <= z + r) {
                    ChunkCoordIntPair location = new ChunkCoordIntPair(i, j);
                    ((CraftPlayer)player).getHandle().chunkCoordIntPairQueue.add(location);
                    ++j;
                }
                ++i;
            }
            Orebfuscator.message(sender, "Chunks within a radius of " + r + " have been sent to you.");
            return true;
        }
        if (sender instanceof Player && !sender.hasPermission("Orebfuscator.admin")) {
            Orebfuscator.message(sender, "You do not have permissions.");
            return true;
        }
        if (args.length <= 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("engine") && args.length > 1) {
            int engine = OrebfuscatorConfig.getEngineMode();
            try {
                engine = new Integer(args[1]);
            }
            catch (NumberFormatException e) {
                Orebfuscator.message(sender, String.valueOf(args[1]) + " is not a number!");
                return true;
            }
            if (engine != 1 && engine != 2) {
                Orebfuscator.message(sender, String.valueOf(args[1]) + " is not a valid EngineMode!");
                return true;
            }
            OrebfuscatorConfig.setEngineMode(engine);
            Orebfuscator.message(sender, "Engine set to: " + engine);
            return true;
        }
        if (args[0].equalsIgnoreCase("updateradius") && args.length > 1) {
            int radius = OrebfuscatorConfig.getUpdateRadius();
            try {
                radius = new Integer(args[1]);
            }
            catch (NumberFormatException e) {
                Orebfuscator.message(sender, String.valueOf(args[1]) + " is not a number!");
                return true;
            }
            OrebfuscatorConfig.setUpdateRadius(radius);
            Orebfuscator.message(sender, "UpdateRadius set to: " + OrebfuscatorConfig.getUpdateRadius());
            return true;
        }
        if (args[0].equalsIgnoreCase("initialradius") && args.length > 1) {
            int radius = OrebfuscatorConfig.getInitialRadius();
            try {
                radius = new Integer(args[1]);
            }
            catch (NumberFormatException e) {
                Orebfuscator.message(sender, String.valueOf(args[1]) + " is not a number!");
                return true;
            }
            OrebfuscatorConfig.setInitialRadius(radius);
            Orebfuscator.message(sender, "InitialRadius set to: " + radius);
            return true;
        }
        if (args[0].equalsIgnoreCase("airgen") && args.length > 1) {
            int airgen = OrebfuscatorConfig.getAirGeneratorMaxChance();
            try {
                airgen = new Integer(args[1]);
            }
            catch (NumberFormatException e) {
                Orebfuscator.message(sender, String.valueOf(args[1]) + " is not a number!");
                return true;
            }
            OrebfuscatorConfig.setAirGeneratorMaxChance(airgen);
            Orebfuscator.message(sender, "AirGeneratorMaxChance set to: " + airgen);
            return true;
        }
        if (args[0].equalsIgnoreCase("proximity") | args[0].equalsIgnoreCase("proximityhider") && args.length > 1) {
            int ProximityHiderDistance = OrebfuscatorConfig.getProximityHiderDistance();
            try {
                ProximityHiderDistance = new Integer(args[1]);
            }
            catch (NumberFormatException e) {
                Orebfuscator.message(sender, String.valueOf(args[1]) + " is not a number!");
                return true;
            }
            OrebfuscatorConfig.setProximityHiderDistance(ProximityHiderDistance);
            Orebfuscator.message(sender, "ProximityHider Distance set to: " + ProximityHiderDistance);
            return true;
        }
        if (args[0].equalsIgnoreCase("enable") || args[0].equalsIgnoreCase("disable")) {
            boolean data = args[0].equalsIgnoreCase("enable");
            if (args[0].equalsIgnoreCase("enable") && args.length == 1) {
                OrebfuscatorConfig.setEnabled(true);
                Orebfuscator.message(sender, "Enabled.");
            }
            if (args[0].equalsIgnoreCase("disable") && args.length == 1) {
                OrebfuscatorConfig.setEnabled(false);
                Orebfuscator.message(sender, "Disabled.");
            }
            if (args.length > 1) {
                if (args[1].equalsIgnoreCase("darknesshide")) {
                    OrebfuscatorConfig.setDarknessHideBlocks(data);
                    Orebfuscator.message(sender, "Darkness obfuscation " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("op")) {
                    OrebfuscatorConfig.setNoObfuscationForOps(data);
                    Orebfuscator.message(sender, "Ops No-Obfuscation " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("perms") || args[1].equalsIgnoreCase("permissions")) {
                    OrebfuscatorConfig.setNoObfuscationForPermission(data);
                    Orebfuscator.message(sender, "Permissions No-Obfuscation " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("proximity")) {
                    OrebfuscatorConfig.setUseProximityHider(data);
                    Orebfuscator.message(sender, "ProximityHider " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("cache")) {
                    OrebfuscatorConfig.setUseCache(data);
                    Orebfuscator.message(sender, "Cache " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("axr")) {
                    OrebfuscatorConfig.setAntiTexturePackAndFreecam(data);
                    Orebfuscator.message(sender, "AntiTexturePackAndFreecam " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("notification")) {
                    OrebfuscatorConfig.setLoginNotification(data);
                    Orebfuscator.message(sender, "Login Notification " + (data ? "enabled" : "disabled") + ".");
                } else if (args[1].equalsIgnoreCase("world") && args.length > 2) {
                    OrebfuscatorConfig.setDisabledWorlds(args[2], !data);
                    Orebfuscator.message(sender, "World \"" + args[2] + "\" obfuscation " + (data ? "enabled" : "disabled") + ".");
                }
            }
        }
        if (args[0].equalsIgnoreCase("reload")) {
            OrebfuscatorConfig.reload();
            Orebfuscator.message(sender, "Reload complete.");
        }
        if (args[0].equalsIgnoreCase("status")) {
            Orebfuscator.message(sender, "Orebfuscator " + Orebfuscator.instance.getDescription().getVersion() + " is: " + (OrebfuscatorConfig.getEnabled() ? "Enabled" : "Disabled"));
            Orebfuscator.message(sender, "EngineMode: " + OrebfuscatorConfig.getEngineMode());
            Orebfuscator.message(sender, "Caching: " + (OrebfuscatorConfig.getUseCache() ? "Enabled" : "Disabled"));
            Orebfuscator.message(sender, "ProximityHider: " + (OrebfuscatorConfig.getUseProximityHider() ? "Enabled" : "Disabled"));
            Orebfuscator.message(sender, "Initial Obfuscation Radius: " + OrebfuscatorConfig.getInitialRadius());
            Orebfuscator.message(sender, "Update Radius: " + OrebfuscatorConfig.getUpdateRadius());
            String disabledWorlds = OrebfuscatorConfig.getDisabledWorlds();
            Orebfuscator.message(sender, "Disabled worlds: " + (disabledWorlds.equals("") ? "None" : disabledWorlds));
        }
        if (args[0].equalsIgnoreCase("clearcache")) {
            ObfuscatedDataCache.ClearCache();
            Orebfuscator.message(sender, "Cache cleared.");
        }
        return true;
    }
}

