/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.hook;

import com.lishid.orebfuscator.Orebfuscator;
import com.lishid.orebfuscator.hook.OrebfuscatorChunkQueue;
import com.lishid.orebfuscator.obfuscation.Calculations;
import com.lishid.orebfuscator.utils.ReflectionHelper;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import net.minecraft.server.Packet56MapChunkBulk;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class ChunkProcessingThread
extends Thread {
    private static LinkedBlockingDeque<ChunkProcessingOrder> queue = new LinkedBlockingDeque();
    private static LinkedList<ChunkProcessingThread> threads = new LinkedList();
    private static int numThreads = Runtime.getRuntime().availableProcessors();
    static ThreadLocal<Deflater> localDeflater;
    AtomicBoolean kill = new AtomicBoolean(false);

    static {
        numThreads = Runtime.getRuntime().availableProcessors() - 1;
        if (numThreads < 1) {
            numThreads = 1;
        }
        localDeflater = new ThreadLocal<Deflater>(){

            @Override
            protected Deflater initialValue() {
                return new Deflater(9);
            }
        };
    }

    public static synchronized void KillAll() {
        for (ChunkProcessingThread thread : threads) {
            thread.kill.set(true);
            thread.interrupt();
        }
        threads.clear();
        queue.clear();
    }

    public static synchronized void SyncThreads() {
        if (numThreads == threads.size()) {
            return;
        }
        int startThreads = numThreads - threads.size();
        int i = 0;
        while (i < startThreads) {
            Orebfuscator.log("Creating new Processing Threads");
            ChunkProcessingThread thread = new ChunkProcessingThread();
            thread.setName("Orebfuscator Processing Thread");
            thread.setPriority(1);
            thread.start();
            threads.add(thread);
            ++i;
        }
    }

    public static void Queue(Packet56MapChunkBulk packet, CraftPlayer player, OrebfuscatorChunkQueue output) {
        ChunkProcessingThread.SyncThreads();
        try {
            queue.put(new ChunkProcessingOrder(packet, player, output));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!Thread.interrupted() && !this.kill.get()) {
            try {
                ChunkProcessingOrder order = queue.take();
                Calculations.Obfuscate(order.packet, order.player);
                this.compress(order.packet);
                order.output.FinishedProcessing(order.packet);
            }
            catch (InterruptedException order) {
            }
            catch (Exception e) {
                Orebfuscator.log(e);
            }
        }
    }

    public void compress(Packet56MapChunkBulk packet) {
        if (ReflectionHelper.getPrivateField(packet, "buffer") != null) {
            return;
        }
        byte[] buildBuffer = (byte[])ReflectionHelper.getPrivateField(packet, "buildBuffer");
        Deflater deflater = localDeflater.get();
        deflater.reset();
        deflater.setInput(buildBuffer);
        deflater.finish();
        byte[] buffer = new byte[buildBuffer.length + 100];
        ReflectionHelper.setPrivateField(packet, "buffer", buffer);
        ReflectionHelper.setPrivateField(packet, "size", deflater.deflate(buffer));
    }

    static class ChunkProcessingOrder {
        Packet56MapChunkBulk packet;
        CraftPlayer player;
        OrebfuscatorChunkQueue output;

        public ChunkProcessingOrder(Packet56MapChunkBulk packet, CraftPlayer player, OrebfuscatorChunkQueue output) {
            this.packet = packet;
            this.player = player;
            this.output = output;
        }
    }
}

