/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.hook;

import com.lishid.orebfuscator.hook.ChunkProcessingThread;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet56MapChunkBulk;
import net.minecraft.server.TileEntity;
import net.minecraft.server.WorldServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class OrebfuscatorChunkQueue
extends LinkedList<ChunkCoordIntPair> {
    private static final long serialVersionUID = -1928681564741152336L;
    List<ChunkCoordIntPair> internalQueue = Collections.synchronizedList(new LinkedList());
    List<ChunkCoordIntPair> outputQueue = Collections.synchronizedList(new LinkedList());
    List<ChunkCoordIntPair> processingQueue = Collections.synchronizedList(new LinkedList());
    CraftPlayer player;
    Thread thread;
    AtomicBoolean kill = new AtomicBoolean(false);

    public OrebfuscatorChunkQueue(CraftPlayer player2, List previousEntries) {
        this.player = player2;
        this.internalQueue.addAll(previousEntries);
    }

    @Override
    public void clear() {
        this.internalQueue.clear();
        super.clear();
    }

    @Override
    public boolean add(ChunkCoordIntPair e) {
        return this.internalQueue.add(e);
    }

    @Override
    public Object[] toArray() {
        final int x = this.player.getLocation().getChunk().getX();
        final int z = this.player.getLocation().getChunk().getZ();
        Collections.sort(this.internalQueue, new Comparator<ChunkCoordIntPair>(){

            @Override
            public int compare(ChunkCoordIntPair a, ChunkCoordIntPair b) {
                return Math.max(Math.abs(a.x - x), Math.abs(a.z - z)) - Math.max(Math.abs(b.x - x), Math.abs(b.z - z));
            }
        });
        return this.internalQueue.toArray();
    }

    @Override
    public boolean contains(Object o) {
        return this.internalQueue.contains(o) || this.processingQueue.contains(o);
    }

    @Override
    public boolean isEmpty() {
        super.clear();
        this.continueProcessing();
        return super.isEmpty();
    }

    private void continueProcessing() {
        while (!this.outputQueue.isEmpty()) {
            ChunkCoordIntPair chunk = this.outputQueue.remove(0);
            List tileEntities = ((WorldServer)this.player.getHandle().world).getTileEntities(chunk.x * 16, 0, chunk.z * 16, chunk.x * 16 + 16, 256, chunk.z * 16 + 16);
            for (Object o : tileEntities) {
                this.updateTileEntity((TileEntity)o);
            }
            this.player.getHandle().p().getTracker().a(this.player.getHandle(), this.player.getHandle().p().getChunkAt(chunk.x, chunk.z));
        }
        if (this.processingQueue.isEmpty() && !this.internalQueue.isEmpty()) {
            LinkedList<Chunk> chunks = new LinkedList<Chunk>();
            while (!this.internalQueue.isEmpty() && chunks.size() < 5) {
                ChunkCoordIntPair chunkcoordintpair = this.internalQueue.remove(0);
                if (chunkcoordintpair == null || !this.player.getHandle().world.isLoaded(chunkcoordintpair.x << 4, 0, chunkcoordintpair.z << 4)) continue;
                this.processingQueue.add(chunkcoordintpair);
                chunks.add(this.player.getHandle().world.getChunkAt(chunkcoordintpair.x, chunkcoordintpair.z));
            }
            if (!chunks.isEmpty()) {
                ChunkProcessingThread.Queue(new Packet56MapChunkBulk(chunks), this.player, this);
            }
        }
    }

    private void updateTileEntity(TileEntity tileentity) {
        Packet packet;
        if (tileentity != null && (packet = tileentity.getUpdatePacket()) != null) {
            this.player.getHandle().netServerHandler.sendPacket(packet);
        }
    }

    @Override
    public ListIterator<ChunkCoordIntPair> listIterator() {
        return new FakeIterator();
    }

    public void FinishedProcessing(Packet56MapChunkBulk packet) {
        this.player.getHandle().netServerHandler.sendPacket((Packet)packet);
        this.outputQueue.addAll(this.processingQueue);
        this.processingQueue.clear();
    }

    private class FakeIterator
    implements ListIterator<ChunkCoordIntPair> {
        private FakeIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ChunkCoordIntPair next() {
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public ChunkCoordIntPair previous() {
            return null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void remove() {
        }

        @Override
        public void set(ChunkCoordIntPair e) {
        }

        @Override
        public void add(ChunkCoordIntPair e) {
        }
    }
}

