/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.listeners;

import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.hithack.BlockHitManager;
import com.lishid.orebfuscator.obfuscation.BlockUpdate;
import net.minecraft.server.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class OrebfuscatorBlockListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        BlockUpdate.Update(event.getBlock());
        BlockHitManager.breakBlock(event.getPlayer(), event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockDamage(BlockDamageEvent event) {
        if (event.isCancelled() || !OrebfuscatorConfig.getUpdateOnDamage()) {
            return;
        }
        if (!BlockUpdate.needsUpdate(event.getBlock())) {
            return;
        }
        if (!BlockHitManager.hitBlock(event.getPlayer(), event.getBlock())) {
            return;
        }
        BlockUpdate.Update(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock().getType() != org.bukkit.Material.SAND && event.getBlock().getType() != org.bukkit.Material.GRAVEL) {
            return;
        }
        if (!this.applyphysics(event.getBlock())) {
            return;
        }
        BlockUpdate.Update(event.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (Block b : event.getBlocks()) {
            BlockUpdate.Update(b);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        BlockUpdate.Update(event.getBlock());
    }

    private boolean applyphysics(Block block) {
        int l = block.getWorld().getBlockTypeIdAt(block.getX(), block.getY() - 1, block.getZ());
        if (l == 0) {
            return true;
        }
        if (l == net.minecraft.server.Block.FIRE.id) {
            return true;
        }
        Material material = net.minecraft.server.Block.byId[l].material;
        return material == Material.WATER ? true : material == Material.LAVA;
    }
}

