/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.obfuscation;

import com.lishid.orebfuscator.Orebfuscator;
import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.cache.ObfuscatedCachedChunk;
import com.lishid.orebfuscator.obfuscation.CalculationsUtil;
import com.lishid.orebfuscator.obfuscation.ChunkInfo;
import com.lishid.orebfuscator.proximityhider.ProximityHider;
import com.lishid.orebfuscator.utils.ReflectionHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.zip.Deflater;
import net.minecraft.server.Packet51MapChunk;
import net.minecraft.server.Packet56MapChunkBulk;
import net.minecraft.server.WorldServer;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class Calculations {
    public static final ThreadLocal<byte[]> buffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };
    public static final ThreadLocal<Deflater> localDeflater = new ThreadLocal<Deflater>(){

        @Override
        protected Deflater initialValue() {
            return new Deflater(-1);
        }
    };

    public static void Obfuscate(Packet56MapChunkBulk packet, CraftPlayer player) {
        if (ReflectionHelper.getPrivateField(Packet56MapChunkBulk.class, packet, "buffer") != null) {
            return;
        }
        ChunkInfo[] infos = Calculations.getInfo(packet, player);
        int chunkNum = 0;
        while (chunkNum < infos.length) {
            ChunkInfo info = infos[chunkNum];
            info.buffer = buffer.get();
            Calculations.ComputeChunkInfoAndObfuscate(info, (byte[])ReflectionHelper.getPrivateField(Packet56MapChunkBulk.class, packet, "buildBuffer"));
            ++chunkNum;
        }
    }

    public static void Obfuscate(Packet51MapChunk packet, CraftPlayer player) {
        Calculations.Obfuscate(packet, player, true);
    }

    public static void Obfuscate(Packet51MapChunk packet, CraftPlayer player, boolean needCompression) {
        ChunkInfo info = Calculations.getInfo(packet, player);
        info.buffer = buffer.get();
        if (info.chunkMask == 0 && info.extraMask == 0) {
            return;
        }
        Calculations.ComputeChunkInfoAndObfuscate(info, (byte[])ReflectionHelper.getPrivateField(Packet51MapChunk.class, packet, "inflatedBuffer"));
        if (needCompression) {
            byte[] chunkInflatedBuffer = (byte[])ReflectionHelper.getPrivateField(Packet51MapChunk.class, packet, "inflatedBuffer");
            byte[] chunkBuffer = (byte[])ReflectionHelper.getPrivateField(Packet51MapChunk.class, packet, "buffer");
            Deflater deflater = localDeflater.get();
            deflater.reset();
            deflater.setInput(chunkInflatedBuffer, 0, chunkInflatedBuffer.length);
            deflater.finish();
            ReflectionHelper.setPrivateField(Packet51MapChunk.class, packet, "size", deflater.deflate(chunkBuffer));
        }
    }

    public static ChunkInfo[] getInfo(Packet56MapChunkBulk packet, CraftPlayer player) {
        ChunkInfo[] infos = new ChunkInfo[packet.d()];
        WorldServer server = player.getHandle().world.getWorld().getHandle();
        int dataStartIndex = 0;
        int[] x = (int[])ReflectionHelper.getPrivateField(packet, "c");
        int[] z = (int[])ReflectionHelper.getPrivateField(packet, "d");
        byte[][] inflatedBuffers = (byte[][])ReflectionHelper.getPrivateField(packet, "inflatedBuffers");
        int[] chunkMask = packet.a;
        int[] extraMask = packet.b;
        int chunkNum = 0;
        while (chunkNum < packet.d()) {
            ChunkInfo info;
            infos[chunkNum] = info = new ChunkInfo();
            info.world = server;
            info.player = player;
            info.chunkX = x[chunkNum];
            info.chunkZ = z[chunkNum];
            info.chunkMask = chunkMask[chunkNum];
            info.extraMask = extraMask[chunkNum];
            info.data = (byte[])ReflectionHelper.getPrivateField(Packet56MapChunkBulk.class, packet, "buildBuffer");
            info.startIndex = dataStartIndex;
            info.size = inflatedBuffers[chunkNum].length;
            dataStartIndex += info.size;
            ++chunkNum;
        }
        return infos;
    }

    public static ChunkInfo getInfo(Packet51MapChunk packet, CraftPlayer player) {
        ChunkInfo info = new ChunkInfo();
        info.world = player.getHandle().world.getWorld().getHandle();
        info.player = player;
        info.chunkX = packet.a;
        info.chunkZ = packet.b;
        info.chunkMask = packet.c;
        info.extraMask = packet.d;
        info.data = (byte[])ReflectionHelper.getPrivateField(Packet51MapChunk.class, packet, "inflatedBuffer");
        info.startIndex = 0;
        return info;
    }

    public static void ComputeChunkInfoAndObfuscate(ChunkInfo info, byte[] original) {
        int i = 0;
        while (i < 16) {
            info.chunkSectionToIndexMap[i] = (info.chunkMask & 1 << i) > 0 ? info.chunkSectionNumber++ : -1;
            if ((info.extraMask & 1 << i) > 0) {
                info.extraSectionToIndexMap[i] = info.extraSectionNumber++;
            }
            ++i;
        }
        info.size = 2048 * (5 * info.chunkSectionNumber + info.extraSectionNumber) + 256;
        info.blockSize = 4096 * info.chunkSectionNumber;
        if (info.startIndex + info.blockSize > info.data.length) {
            return;
        }
        if (!OrebfuscatorConfig.isWorldDisabled(info.world.getWorld().getName()) && OrebfuscatorConfig.obfuscateForPlayer((Player)info.player) && OrebfuscatorConfig.getEnabled()) {
            byte[] obfuscated = Calculations.Obfuscate(info, original);
            System.arraycopy(obfuscated, 0, original, info.startIndex, info.blockSize);
        }
    }

    public static byte[] Obfuscate(ChunkInfo info, byte[] original) {
        int maxChance;
        ObfuscatedCachedChunk cache = null;
        long hash = 0L;
        ArrayList<Block> proximityBlocks = new ArrayList<Block>();
        info.useCache = false;
        int initialRadius = OrebfuscatorConfig.getInitialRadius();
        if (info.blockSize > info.buffer.length) {
            info.buffer = new byte[info.blockSize];
            buffer.set(info.buffer);
        }
        System.arraycopy(info.data, info.startIndex, info.buffer, 0, info.blockSize);
        if (OrebfuscatorConfig.getUseCache()) {
            File cacheFolder = new File(OrebfuscatorConfig.getCacheFolder(), info.world.getWorld().getName());
            cache = new ObfuscatedCachedChunk(cacheFolder, info.chunkX, info.chunkZ, initialRadius, OrebfuscatorConfig.getUseProximityHider());
            info.useCache = true;
            hash = CalculationsUtil.Hash(info.buffer, info.blockSize);
            cache.Read();
            long storedHash = cache.getHash();
            if (storedHash == hash) {
                byte[] data = cache.data;
                int[] chestList = cache.proximityBlockList;
                if (data != null) {
                    if (chestList != null) {
                        int i = 0;
                        while (i < chestList.length) {
                            Block b = info.player.getWorld().getBlockAt(chestList[i], chestList[i + 1], chestList[i + 2]);
                            proximityBlocks.add(b);
                            i += 3;
                        }
                    }
                    ProximityHider.AddProximityBlocks(info.player, proximityBlocks);
                    return data;
                }
            }
        }
        int randomIncrement = 0;
        int randomIncrement2 = 0;
        boolean obfuscate = false;
        boolean specialObfuscate = false;
        int engineMode = OrebfuscatorConfig.getEngineMode();
        int incrementMax = maxChance = OrebfuscatorConfig.getAirGeneratorMaxChance();
        int randomBlocksLength = OrebfuscatorConfig.getRandomBlocks(false).length;
        boolean randomAlternate = false;
        int dataIndexModifier = 0;
        int startX = info.chunkX << 4;
        int startZ = info.chunkZ << 4;
        int i = 0;
        while (i < 16) {
            if ((info.chunkMask & 1 << i) != 0) {
                int indexDataStart = dataIndexModifier * 4096;
                int tempIndex = 0;
                OrebfuscatorConfig.shuffleRandomBlocks();
                int y = 0;
                while (y < 16) {
                    int z = 0;
                    while (z < 16) {
                        incrementMax = (maxChance + OrebfuscatorConfig.random(maxChance)) / 2;
                        int x = 0;
                        while (x < 16) {
                            int index = indexDataStart + tempIndex;
                            byte data = info.data[info.startIndex + index];
                            obfuscate = false;
                            specialObfuscate = false;
                            if (OrebfuscatorConfig.isObfuscated(data)) {
                                if (initialRadius == 0) {
                                    if (OrebfuscatorConfig.getUseProximityHider() && OrebfuscatorConfig.isProximityObfuscated(data)) {
                                        if (!Calculations.areAjacentBlocksTransparent(info, startX + x, (i << 4) + y, startZ + z, 1)) {
                                            obfuscate = true;
                                        }
                                    } else {
                                        obfuscate = true;
                                    }
                                } else if (!Calculations.areAjacentBlocksTransparent(info, startX + x, (i << 4) + y, startZ + z, initialRadius)) {
                                    obfuscate = true;
                                }
                            }
                            if (!obfuscate && OrebfuscatorConfig.getUseProximityHider() && OrebfuscatorConfig.isProximityObfuscated(data) && (i << 4) + y <= OrebfuscatorConfig.getProximityHiderEnd()) {
                                proximityBlocks.add(CalculationsUtil.getBlockAt(info.player.getWorld(), startX + x, (i << 4) + y, startZ + z));
                                obfuscate = true;
                                if (OrebfuscatorConfig.getUseSpecialBlockForProximityHider()) {
                                    specialObfuscate = true;
                                }
                            }
                            if (!obfuscate && OrebfuscatorConfig.getDarknessHideBlocks() && OrebfuscatorConfig.isDarknessObfuscated(data)) {
                                if (initialRadius == 0) {
                                    obfuscate = true;
                                } else if (!Calculations.areAjacentBlocksBright(info, startX + x, (i << 4) + y, startZ + z, initialRadius)) {
                                    obfuscate = true;
                                }
                            }
                            if (obfuscate) {
                                if (specialObfuscate) {
                                    info.buffer[index] = (byte)OrebfuscatorConfig.getProximityHiderID();
                                } else {
                                    randomIncrement2 = CalculationsUtil.increment(randomIncrement2, incrementMax);
                                    if (engineMode == 1) {
                                        info.buffer[index] = 1;
                                    } else if (engineMode == 2) {
                                        if (randomBlocksLength > 1) {
                                            randomIncrement = CalculationsUtil.increment(randomIncrement, randomBlocksLength);
                                        }
                                        info.buffer[index] = OrebfuscatorConfig.getRandomBlock(randomIncrement, randomAlternate);
                                        boolean bl = randomAlternate = !randomAlternate;
                                    }
                                    if (OrebfuscatorConfig.getAntiTexturePackAndFreecam() && randomIncrement2 == 0) {
                                        info.buffer[index] = 0;
                                    }
                                }
                            }
                            ++tempIndex;
                            ++x;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++dataIndexModifier;
            }
            ++i;
        }
        ProximityHider.AddProximityBlocks(info.player, proximityBlocks);
        if (info.useCache) {
            cache.initialRadius = initialRadius;
            int[] chestList = new int[proximityBlocks.size() * 3];
            int i2 = 0;
            while (i2 < proximityBlocks.size()) {
                Block b = proximityBlocks.get(i2);
                if (b != null) {
                    chestList[i2 * 3] = b.getX();
                    chestList[i2 * 3 + 1] = b.getY();
                    chestList[i2 * 3 + 2] = b.getZ();
                }
                ++i2;
            }
            cache.Write(hash, info.buffer, chestList);
        }
        if (cache != null) {
            cache.free();
        }
        return info.buffer;
    }

    public static boolean areAjacentBlocksTransparent(ChunkInfo info, int x, int y, int z, int countdown) {
        short id = 0;
        boolean foundID = false;
        if (y >= info.world.getHeight() || y < 0) {
            return true;
        }
        int section = info.chunkSectionToIndexMap[y >> 4];
        if ((info.chunkMask & 1 << (y >> 4)) > 0 && x >> 4 == info.chunkX && z >> 4 == info.chunkZ) {
            int cX = x % 16 < 0 ? x % 16 + 16 : x % 16;
            int cZ = z % 16 < 0 ? z % 16 + 16 : z % 16;
            int index = section * 4096 + (y % 16 << 8) + (cZ << 4) + cX;
            try {
                id = info.data[info.startIndex + index];
                foundID = true;
            }
            catch (Exception e) {
                Orebfuscator.log(e);
            }
        }
        if (!foundID) {
            if (CalculationsUtil.isChunkLoaded(info.world, x >> 4, z >> 4)) {
                id = (byte)info.world.getTypeId(x, y, z);
            } else {
                id = 1;
                info.useCache = false;
            }
        }
        if (OrebfuscatorConfig.isBlockTransparent(id)) {
            return true;
        }
        if (countdown == 0) {
            return false;
        }
        if (Calculations.areAjacentBlocksTransparent(info, x, y + 1, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksTransparent(info, x, y - 1, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksTransparent(info, x + 1, y, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksTransparent(info, x - 1, y, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksTransparent(info, x, y, z + 1, countdown - 1)) {
            return true;
        }
        return Calculations.areAjacentBlocksTransparent(info, x, y, z - 1, countdown - 1);
    }

    public static boolean areAjacentBlocksBright(ChunkInfo info, int x, int y, int z, int countdown) {
        if (CalculationsUtil.isChunkLoaded(info.world, x >> 4, z >> 4)) {
            if (info.world.getLightLevel(x, y, z) > 0) {
                return true;
            }
        } else {
            return true;
        }
        if (countdown == 0) {
            return false;
        }
        if (Calculations.areAjacentBlocksBright(info, x, y + 1, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksBright(info, x, y - 1, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksBright(info, x + 1, y, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksBright(info, x - 1, y, z, countdown - 1)) {
            return true;
        }
        if (Calculations.areAjacentBlocksBright(info, x, y, z + 1, countdown - 1)) {
            return true;
        }
        return Calculations.areAjacentBlocksBright(info, x, y, z - 1, countdown - 1);
    }
}

