/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.orebfuscator.proximityhider;

import com.lishid.orebfuscator.Orebfuscator;
import com.lishid.orebfuscator.OrebfuscatorConfig;
import com.lishid.orebfuscator.obfuscation.CalculationsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ProximityHider
extends Thread
implements Runnable {
    public static HashMap<Player, HashSet<Block>> proximityHiderTracker = new HashMap();
    public static HashMap<Player, Location> playersToCheck = new HashMap();
    public static final Object PlayerLock = new Object();
    public static final Object BlockLock = new Object();
    public static ProximityHider thread = new ProximityHider();
    public long lastExecute = System.currentTimeMillis();
    public AtomicBoolean kill = new AtomicBoolean(false);
    public static boolean running = false;

    public static void Load() {
        running = true;
        if (thread == null || thread.isInterrupted() || !thread.isAlive()) {
            thread = new ProximityHider();
            thread.setName("ProximityHider Thread");
            thread.setPriority(5);
            thread.start();
        }
    }

    public static void terminate() {
        if (thread != null) {
            ProximityHider.thread.kill.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted() && !this.kill.get()) {
            try {
                long timeWait = this.lastExecute + (long)OrebfuscatorConfig.getProximityHiderRate() - System.currentTimeMillis();
                this.lastExecute = System.currentTimeMillis();
                if (timeWait > 0L) {
                    Thread.sleep(timeWait);
                }
                if (!OrebfuscatorConfig.getUseProximityHider()) {
                    running = false;
                    return;
                }
                HashMap<Player, Location> newPlayers = new HashMap<Player, Location>();
                Object object = PlayerLock;
                synchronized (object) {
                    newPlayers.putAll(playersToCheck);
                    playersToCheck.clear();
                }
                for (Player p : newPlayers.keySet()) {
                    if (p == null || !proximityHiderTracker.containsKey(p)) continue;
                    Location loc1 = p.getLocation();
                    Location loc2 = (Location)newPlayers.get(p);
                    if (!loc1.getWorld().equals(loc2.getWorld())) {
                        proximityHiderTracker.remove(p);
                        continue;
                    }
                    if (loc1.getBlockX() == loc2.getBlockX() && loc1.getBlockY() == loc2.getBlockY() && loc1.getBlockZ() == loc2.getBlockZ()) continue;
                    HashSet blocks = new HashSet();
                    HashSet<Block> removedBlocks = new HashSet<Block>();
                    Object object2 = BlockLock;
                    synchronized (object2) {
                        if (proximityHiderTracker.get(p) != null) {
                            blocks.addAll(proximityHiderTracker.get(p));
                        }
                    }
                    for (Block b : blocks) {
                        if (b == null || p == null || b.getWorld() == null || p.getWorld() == null) {
                            removedBlocks.add(b);
                            continue;
                        }
                        if (!p.getWorld().equals(b.getWorld())) {
                            removedBlocks.add(b);
                            continue;
                        }
                        if (!(p.getLocation().distance(b.getLocation()) < (double)OrebfuscatorConfig.getProximityHiderDistance())) continue;
                        removedBlocks.add(b);
                        if (!CalculationsUtil.isChunkLoaded(b.getWorld(), b.getChunk().getX(), b.getChunk().getZ())) continue;
                        p.sendBlockChange(b.getLocation(), b.getTypeId(), b.getData());
                    }
                    object2 = BlockLock;
                    synchronized (object2) {
                        for (Block b : removedBlocks) {
                            proximityHiderTracker.get(p).remove(b);
                        }
                    }
                }
            }
            catch (Exception e) {
                Orebfuscator.log(e);
            }
        }
        running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restart() {
        ProximityHider proximityHider = thread;
        synchronized (proximityHider) {
            if (thread.isInterrupted() || !thread.isAlive()) {
                running = false;
            }
            if (!running && OrebfuscatorConfig.getUseProximityHider()) {
                ProximityHider.Load();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void AddProximityBlocks(CraftPlayer player, ArrayList<Block> blocks) {
        ProximityHider.restart();
        Object object = BlockLock;
        synchronized (object) {
            if (!proximityHiderTracker.containsKey(player)) {
                proximityHiderTracker.put((Player)player, new HashSet());
            }
            for (Block b : blocks) {
                proximityHiderTracker.get(player).add(b);
            }
        }
    }
}

