package net.minecraft.src;

import java.io.*;
import java.util.*;
import net.minecraft.client.Minecraft;

public class AS_Settings_MultiMine
{
	public AS_Settings_MultiMine()
	{
	}
	
	public static int maxDamagedBlocks = 15;
	public static float blockSelfRepairRate = 0.001F;
	public static boolean blockSelfRepair = true;
	public static float mineSpeed = 1.0F;
	public static boolean mineSpeedChanged = false;
	private static File configfile = new File(Minecraft.getMinecraftDir(), "mods/MultiMine.txt");
	
	public static void InitSettings()
	{
		Properties properties = new Properties();
		
		if (configfile.exists())
		{
			System.out.println("MultiMine config found, proceeding...");
		
			try
			{
				properties.load(new FileInputStream(configfile));
			}
			catch (IOException localIOException)
			{
				System.out.println("MultiMine config exception: "+localIOException);
			}
			
			maxDamagedBlocks = Integer.parseInt(properties.getProperty("maxDamagedBlocks", "15"));
			blockSelfRepairRate = Float.parseFloat(properties.getProperty("blockSelfRepairRate", "0"));
			mineSpeed = Float.parseFloat(properties.getProperty("mineSpeed", "1.0"));
			
			if (blockSelfRepairRate > 0)
			{
				blockSelfRepair = true;
			}
			
			if (mineSpeed != 1.0F)
			{
				mineSpeedChanged = true;
			}
		}
		else
		{
			System.out.println("No MultiMine config found, trying to create...");
		
			try
			{
				configfile.createNewFile();
				properties.load(new FileInputStream(configfile));
			}
			catch (IOException localIOException)
			{
				System.out.println("MultiMine config exception: "+localIOException);
			}
			
			properties.setProperty("maxDamagedBlocks", "15");
			properties.setProperty("blockSelfRepairRate", "0");
			properties.setProperty("mineSpeed", "1.0");
			
			try
			{
				FileOutputStream fostream = new FileOutputStream(configfile);
				properties.store(fostream, "maxDamagedBlocks means how many Blocks you can leave partially Damaged at once. blockSelfRepairRate states how much Damage Blocks regenerate each tick, 0.01 being one percent damage. mineSpeed allows you to adjust the speed at which you break blocks.");
			}
			catch (IOException localIOException)
			{
				System.out.println("MultiMine config exception: "+localIOException);
			}
		}
	}
}
