/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.process;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launcher.process.JavaProcess;
import ru.turikhay.util.OS;

public class JavaProcessLauncher {
    private final String jvmPath;
    private final List<String> commands;
    private File directory;
    private ProcessBuilder process;

    public JavaProcessLauncher(String jvmPath, String[] commands) {
        if (jvmPath == null) {
            jvmPath = OS.getJavaPath();
        }
        this.jvmPath = jvmPath;
        this.commands = new ArrayList<String>();
        Collections.addAll(this.commands, commands);
    }

    public JavaProcess start() throws IOException {
        List<String> full = this.getFullCommands();
        return new JavaProcess(full, this.createProcess().start());
    }

    public ProcessBuilder createProcess() {
        if (this.process == null) {
            this.process = new ProcessBuilder(this.getFullCommands()).directory(this.directory).redirectErrorStream(true);
        }
        return this.process;
    }

    List<String> getFullCommands() {
        ArrayList<String> result = new ArrayList<String>(this.commands);
        result.add(0, this.getJavaPath());
        return result;
    }

    public String getCommandsAsString() {
        List<String> parts = this.getFullCommands();
        StringBuilder full = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (first) {
                first = false;
            } else {
                full.append(' ');
            }
            full.append(part);
        }
        return full.toString();
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void addCommand(Object command) {
        this.commands.add(command.toString());
    }

    public void addCommand(Object key, Object value) {
        this.commands.add(key.toString());
        this.commands.add(value.toString());
    }

    public void addCommands(Object[] commands) {
        Object[] arr$ = commands;
        int len$ = commands.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object c = arr$[i$];
            this.commands.add(c.toString());
        }
    }

    public void addSplitCommands(Object commands) {
        this.addCommands(commands.toString().split(" "));
    }

    public JavaProcessLauncher directory(File directory) {
        this.directory = directory;
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    String getJavaPath() {
        return this.jvmPath;
    }

    public String toString() {
        return "JavaProcessLauncher[commands=" + this.commands + ", java=" + this.jvmPath + "]";
    }
}

