/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.component;

import java.util.concurrent.Semaphore;
import ru.turikhay.tlauncher.component.RefreshableComponent;
import ru.turikhay.tlauncher.managers.ComponentManager;

public abstract class InterruptibleComponent
extends RefreshableComponent {
    protected final boolean[] refreshList;
    private int lastRefreshID;
    protected final Semaphore semaphore = new Semaphore(1);
    protected boolean lastResult;

    protected InterruptibleComponent(ComponentManager manager) throws Exception {
        this(manager, 64);
    }

    private InterruptibleComponent(ComponentManager manager, int listSize) throws Exception {
        super(manager);
        if (listSize < 1) {
            throw new IllegalArgumentException("Invalid list size: " + listSize + " < 1");
        }
        this.refreshList = new boolean[listSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean refresh() {
        boolean var2;
        if (this.semaphore.tryAcquire()) {
            boolean e;
            try {
                e = this.lastResult = this.refresh(this.nextID());
            }
            finally {
                this.semaphore.release();
            }
            return e;
        }
        try {
            boolean e;
            this.semaphore.acquire();
            boolean bl = e = this.lastResult;
            return bl;
        }
        catch (InterruptedException var11) {
            var11.printStackTrace();
            var2 = false;
        }
        finally {
            this.semaphore.release();
        }
        return var2;
    }

    public synchronized void stopRefresh() {
        for (int i = 0; i < this.refreshList.length; ++i) {
            this.refreshList[i] = false;
        }
    }

    protected synchronized int nextID() {
        int next;
        int listSize = this.refreshList.length;
        if ((next = this.lastRefreshID++) >= listSize) {
            next = 0;
        }
        this.lastRefreshID = next;
        return next;
    }

    protected boolean isCancelled(int refreshID) {
        return !this.refreshList[refreshID];
    }

    protected abstract boolean refresh(int var1);
}

