/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import ru.turikhay.tlauncher.configuration.SimpleConfiguration;
import ru.turikhay.util.U;

public class LangConfiguration
extends SimpleConfiguration {
    private final Locale[] locales;
    private final Properties[] prop;
    private int i;

    public LangConfiguration(Locale[] locales, Locale select) throws IOException {
        int var8;
        int defLocale;
        if (locales == null) {
            throw new NullPointerException();
        }
        int size = locales.length;
        this.locales = locales;
        this.prop = new Properties[size];
        for (defLocale = 0; defLocale < size; ++defLocale) {
            Locale i = locales[defLocale];
            if (i == null) {
                throw new NullPointerException("Locale at #" + defLocale + " is NULL!");
            }
            String i$ = i.toString();
            InputStream key = this.getClass().getResourceAsStream("/lang/" + i$);
            if (key == null) {
                throw new IOException("Cannot find locale file for: " + i$);
            }
            this.prop[defLocale] = LangConfiguration.loadFromStream(key);
            if (!i$.equals("en_US")) continue;
            LangConfiguration.copyProperties(this.prop[defLocale], this.properties, true);
        }
        defLocale = -1;
        for (var8 = 0; var8 < size; ++var8) {
            if (!locales[var8].toString().equals("ru_RU")) continue;
            defLocale = var8;
            break;
        }
        if (defLocale != -1) {
            for (Object var10 : this.prop[defLocale].keySet()) {
                for (int var12 = 0; var12 < size; ++var12) {
                    if (var12 == defLocale || this.prop[var12].containsKey(var10)) continue;
                    U.log("Locale", locales[var12], "doesn't contain key", var10);
                }
            }
            for (var8 = 0; var8 < size; ++var8) {
                if (var8 == defLocale) continue;
                for (Object var13 : this.prop[var8].keySet()) {
                    if (this.prop[defLocale].containsKey(var13)) continue;
                    U.log("Locale", locales[var8], "contains redundant key", var13);
                }
            }
        }
        this.setSelected(select);
    }

    public Locale[] getLocales() {
        return this.locales;
    }

    public Locale getSelected() {
        return this.locales[this.i];
    }

    public void setSelected(Locale select) {
        if (select == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.locales.length; ++i) {
            if (!this.locales[i].equals(select)) continue;
            this.i = i;
            return;
        }
        throw new IllegalArgumentException("Cannot find Locale:" + select);
    }

    public String nget(String key) {
        if (key == null) {
            return null;
        }
        String value = this.prop[this.i].getProperty(key);
        return value == null ? this.getDefault(key) : value;
    }

    @Override
    public String get(String key) {
        String value = this.nget(key);
        return value == null ? key : value;
    }

    public String nget(String key, Object ... vars) {
        String value = this.get(key);
        if (value == null) {
            return null;
        }
        String[] variables = LangConfiguration.checkVariables(vars);
        for (int i = 0; i < variables.length; ++i) {
            value = value.replace("%" + i, variables[i]);
        }
        return value;
    }

    public String get(String key, Object ... vars) {
        String value = this.nget(key, vars);
        return value == null ? key : value;
    }

    @Override
    public void set(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefault(String key) {
        return super.get(key);
    }

    private static String[] checkVariables(Object[] check) {
        if (check == null) {
            throw new NullPointerException();
        }
        if (check.length == 1 && check[0] == null) {
            return new String[0];
        }
        String[] string = new String[check.length];
        for (int i = 0; i < check.length; ++i) {
            if (check[i] == null) {
                throw new NullPointerException("Variable at index " + i + " is NULL!");
            }
            string[i] = check[i].toString();
        }
        return string;
    }
}

