/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.managers.popup.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.entity.ServerInfo;
import ru.turikhay.tlauncher.entity.ServerInfoPage;
import ru.turikhay.tlauncher.managers.popup.menu.UtilFilter;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.menu.PopupMenuController;
import ru.turikhay.util.U;

public class PopupMenuManager
implements MinecraftListener {
    private Map<String, PopupMenuController> hashMap;
    private List<VersionSyncInfo> versionList;
    private PopupMenuController last;
    private boolean block = false;
    private UtilFilter util;
    private TLauncherFrame component;

    public PopupMenuManager(List<VersionSyncInfo> list) {
        UIManager.getLookAndFeelDefaults().put("MenuItem.selectionBackground", Color.BLACK);
        this.util = new UtilFilter();
        this.hashMap = new HashMap<String, PopupMenuController>();
        this.versionList = list;
    }

    public void processingEvent(final String serverId, final int y, final int x) {
        if (this.block) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    U.debug("all server =" + PopupMenuManager.this.hashMap.size());
                    if (PopupMenuManager.this.last == null || PopupMenuManager.this.last != PopupMenuManager.this.hashMap.get(serverId) || !PopupMenuManager.this.last.isVisible()) {
                        PopupMenuManager.this.cancelLastPopup();
                        PopupMenuManager.this.last = (PopupMenuController)PopupMenuManager.this.hashMap.get(serverId);
                        if (PopupMenuManager.this.last != null) {
                            PopupMenuManager.this.last.show(x, y);
                        } else {
                            U.debug("server id hansn't found = " + serverId);
                        }
                    }
                }
            });
        }
    }

    public void cancelLastPopup() {
        if (this.last != null) {
            this.last.hidePopupMenu();
        }
    }

    @Override
    public void onMinecraftPrepare() {
        this.unenablePopup();
    }

    @Override
    public void onMinecraftAbort() {
        this.enablePopup();
    }

    @Override
    public void onMinecraftLaunch() {
        this.unenablePopup();
    }

    @Override
    public void onMinecraftClose() {
        this.enablePopup();
    }

    @Override
    public void onMinecraftError(Throwable e) {
        this.enablePopup();
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        this.enablePopup();
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        this.enablePopup();
    }

    public void enablePopup() {
        this.block = true;
    }

    public void unenablePopup() {
        this.block = false;
    }

    private void log(String line) {
        U.log("[PopupMenuManager] " + line);
    }

    public void putServers(List<?> listServerInfo, Class<? extends ServerInfo> classServer, Component comp) {
        if (classServer == ServerInfo.class) {
            for (ServerInfo info : listServerInfo) {
                U.debug(info.getServerId());
                this.hashMap.put(info.getServerId(), new PopupMenuController(comp, info.getAddress(), info.getAddress().split(":")[0], this.util.findAvailableVersions(info, this.versionList), info.getServerId()));
            }
        }
        if (classServer == ServerInfoPage.class) {
            for (ServerInfo info : listServerInfo) {
                U.debug(info.getServerId());
                this.hashMap.put(info.getServerId(), new PopupMenuController(comp, info.getAddress(), info.getAddress().split(":")[0], this.util.findAvailableVersions(info, this.versionList), info.getServerId()));
            }
        }
    }
}

