/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ru.turikhay.tlauncher.downloader.Downloadable;
import ru.turikhay.tlauncher.downloader.Downloader;
import ru.turikhay.tlauncher.downloader.DownloaderListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.listener.UpdateUIListener;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.progress.DownloaderProgress;
import ru.turikhay.tlauncher.ui.swing.ImagePanel;
import ru.turikhay.tlauncher.updater.AutoUpdater;
import ru.turikhay.tlauncher.updater.Update;
import ru.turikhay.tlauncher.updater.UpdateListener;
import ru.turikhay.tlauncher.updater.Updater;
import ru.turikhay.tlauncher.updater.UpdaterListener;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public class AutoUpdaterFrame
extends JFrame
implements DownloaderListener,
UpdaterListener,
UpdateListener {
    private static final long serialVersionUID = -1184260781662212096L;
    private static final int ANIMATION_TICK = 1;
    private static final double OPACITY_STEP = 0.005;
    private final AutoUpdaterFrame instance = this;
    private final Color border = new Color(255, 255, 255, 255);
    private final JPanel titlepan;
    private final JPanel pan;
    private final LocalizableLabel label;
    private final DownloaderProgress pb;
    private final ImagePanel hide;
    private final ImagePanel skip;
    private final Object animationLock = new Object();
    private boolean closed;
    private boolean canSkip;

    public AutoUpdaterFrame(AutoUpdater updater) {
        this.setPreferredSize(new Dimension(350, 60));
        this.setResizable(false);
        this.setUndecorated(true);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setDefaultCloseOperation(3);
        this.pan = new JPanel(){
            private static final long serialVersionUID = -8469500310564854471L;
            protected Insets insets = new Insets(5, 10, 10, 10);
            protected Color background = new Color(255, 255, 255, 220);

            @Override
            public void paintComponent(Graphics g0) {
                Graphics2D g = (Graphics2D)g0;
                int arc = 16;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(this.background);
                g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
                g.setColor(AutoUpdaterFrame.this.border);
                for (int shadow = 1; shadow < 2; ++shadow) {
                    g.drawRoundRect(shadow - 1, shadow - 1, this.getWidth() - 2 * shadow + 1, this.getHeight() - 2 * shadow + 1, arc, arc);
                }
                Color var6 = U.shiftAlpha(Color.gray, -200);
                int x = 2;
                while (true) {
                    if ((var6 = U.shiftAlpha(var6, -8)).getAlpha() == 0) {
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        super.paintComponent(g0);
                        return;
                    }
                    g.setColor(var6);
                    g.drawRoundRect(x - 1, x - 1, this.getWidth() - 2 * x + 1, this.getHeight() - 2 * x + 1, arc - 2 * x + 1, arc - 2 * x + 1);
                    ++x;
                }
            }

            @Override
            public Insets getInsets() {
                return this.insets;
            }
        };
        this.pan.setOpaque(false);
        this.pan.setLayout(new BorderLayout());
        this.add(this.pan);
        this.titlepan = new JPanel();
        this.titlepan.setOpaque(false);
        this.titlepan.setLayout(new FlowLayout(2));
        this.hide = new ImagePanel("hide.png", 0.75f, 0.5f, false, true){
            private static final long serialVersionUID = 513294577418505533L;

            @Override
            protected boolean onClick() {
                if (!super.onClick()) {
                    return false;
                }
                AutoUpdaterFrame.this.instance.setExtendedState(1);
                return true;
            }
        };
        this.hide.setToolTipText(Localizable.get("autoupdater.buttons.hide"));
        this.titlepan.add(this.hide);
        this.skip = new ImagePanel("skip.png", 0.75f, 0.5f, false, true){
            private static final long serialVersionUID = 513294577418505533L;

            @Override
            protected boolean onClick() {
                if (super.onClick() && AutoUpdaterFrame.this.canSkip) {
                    AutoUpdaterFrame.this.handleClose();
                    return true;
                }
                return false;
            }
        };
        this.skip.setToolTipText(Localizable.get("autoupdater.buttons.skip"));
        this.titlepan.add(this.skip);
        this.pan.add("East", this.titlepan);
        this.label = new LocalizableLabel("autoupdater.preparing");
        this.label.setOpaque(false);
        this.pan.add("West", this.label);
        this.pb = new DownloaderProgress(this){
            private static final long serialVersionUID = 4001100361699294798L;

            @Override
            public void onDownloaderStart(Downloader d, int files) {
                this.startProgress();
                this.setIndeterminate(true);
            }

            @Override
            public void onDownloaderFileComplete(Downloader d, Downloadable file) {
                this.setIndeterminate(false);
            }

            @Override
            public void onDownloaderProgress(Downloader d, double dprogress, double speed) {
                if (dprogress > 0.0) {
                    int progress = (int)(dprogress * 100.0);
                    if (this.getValue() > progress) {
                        return;
                    }
                    this.setIndeterminate(false);
                    this.setValue(progress);
                    this.setCenterString(progress + "%");
                    this.setEastString(U.setFractional(speed, 2) + " kb/s");
                }
            }
        };
        this.pb.startProgress();
        this.pb.setIndeterminate(true);
        this.pan.add("South", this.pb);
        this.setCanSkip(true);
        updater.getLauncher().getDownloader().addListener(this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFrame() {
        if (!this.closed) {
            float opacity = 0.0f;
            Object var2 = this.animationLock;
            Object object = this.animationLock;
            synchronized (object) {
                try {
                    this.setOpacity(opacity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.setVisible(true);
                while (opacity < 1.0f) {
                    if ((opacity = (float)((double)opacity + 0.005)) > 1.0f) {
                        opacity = 1.0f;
                    }
                    try {
                        this.setOpacity(opacity);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    U.sleepFor(1L);
                }
                AsyncThread.execute(new Runnable(){

                    @Override
                    public void run() {
                        U.sleepFor(2500L);
                        if (AutoUpdaterFrame.this.canSkip) {
                            AutoUpdaterFrame.this.showButtons();
                        }
                    }
                });
            }
        }
    }

    private void showButtons() {
        this.hide.show();
        this.skip.show();
    }

    private void hideButtons() {
        this.skip.hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFrame() {
        if (this.closed) {
            this.dispose();
        } else {
            float opacity = 1.0f;
            Object var2 = this.animationLock;
            Object object = this.animationLock;
            synchronized (object) {
                try {
                    this.setOpacity(opacity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                while (opacity > 0.0f) {
                    if ((opacity = (float)((double)opacity - 0.005)) < 0.0f) {
                        opacity = 0.0f;
                    }
                    try {
                        this.setOpacity(opacity);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    U.sleepFor(1L);
                }
                this.dispose();
            }
        }
        this.closed = true;
    }

    public boolean canSkip() {
        return this.canSkip;
    }

    public void setCanSkip(boolean b) {
        this.canSkip = b;
        if (!b) {
            this.hideButtons();
        }
    }

    private void handleClose() {
        this.label.setText("autoupdater.opening", TLauncher.getVersion());
        this.closeFrame();
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void onUpdateError(Update u, Throwable e) {
        if (!this.closed) {
            if (Alert.showLocQuestion("updater.error.title", "updater.download-error", e)) {
                UpdateUIListener.openUpdateLink(u.getLink());
            }
            this.handleClose();
        }
    }

    @Override
    public void onUpdateDownloading(Update u) {
        this.label.setText("autoupdater.downloading", u.getVersion());
    }

    @Override
    public void onUpdateDownloadError(Update u, Throwable e) {
        this.onUpdateError(u, e);
    }

    @Override
    public void onUpdateReady(Update u) {
        this.setCanSkip(true);
    }

    @Override
    public void onUpdateApplying(Update u) {
    }

    @Override
    public void onUpdateApplyError(Update u, Throwable e) {
        if (Alert.showLocQuestion("updater.save-error", e)) {
            UpdateUIListener.openUpdateLink(u.getLink());
        }
    }

    @Override
    public void onUpdaterRequesting(Updater u) {
        this.label.setText("autoupdater.requesting");
    }

    @Override
    public void onUpdaterErrored(Updater.SearchFailed failed) {
        this.handleClose();
    }

    @Override
    public void onUpdaterSucceeded(Updater.SearchSucceeded succeeded) {
        Update update = succeeded.getResponse().getUpdate();
        this.showUpdateMessage(update);
        if (update.isApplicable()) {
            update.addListener(this);
        } else {
            this.label.setText("autoupdater.opening");
            this.handleClose();
        }
    }

    private void showUpdateMessage(Update update) {
        if (update.isApplicable()) {
            String[] array = update.getDescription().split(",");
            StringBuilder builderChanges = new StringBuilder();
            String message = "";
            StringBuilder bulderLinks = new StringBuilder();
            String link = "";
            link = "http://minecraft-mod.su/";
            message = update.isMandatory() ? Localizable.get("launcher.update.message.mandatory") : Localizable.get("launcher.update.message.optional");
            for (int i = 0; i < array.length; ++i) {
                if (array[i].isEmpty()) continue;
                builderChanges.append("-").append(array[i]).append("\n");
            }
            if (builderChanges.length() > 0) {
                builderChanges.deleteCharAt(builderChanges.length() - 1);
            }
            bulderLinks.append(Localizable.get("launcher.update.message.detailed")).append(" ").append("<a href=\"").append(link);
            if (!link.equals("http://en-minecraft.org/programs/1-launcher.html")) {
                bulderLinks.append(update.getVersion());
            }
            bulderLinks.append("\">").append(Localizable.get("launcher.update.link")).append("</a>").append("<br>");
            bulderLinks.append(Localizable.get("launcher.update.message.problem"));
            if (update.isMandatory()) {
                Alert.ShowUpdaterMessage(message, builderChanges.toString(), bulderLinks.toString(), Localizable.get("launcher.update.title"), 1);
            } else {
                update.setUserChoose(Alert.ShowUpdaterMessage(message, builderChanges.toString(), bulderLinks.toString(), Localizable.get("launcher.update.title"), 3));
            }
        }
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        this.setCanSkip(false);
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed) {
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        this.pb.setValue(100);
        this.pb.setCenterString("100%");
        this.pb.setEastString(null);
    }
}

