/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.browser;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javax.xml.bind.DatatypeConverter;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;
import ru.turikhay.tlauncher.handlers.ExceptionHandler;
import ru.turikhay.tlauncher.managers.popup.menu.page.ServerInfoPageController;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.browser.BrowserBridge;
import ru.turikhay.tlauncher.ui.browser.BrowserHolder;
import ru.turikhay.tlauncher.ui.browser.JFXStartPageLoader;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;
import ru.turikhay.util.statistics.StatisticsCommand;
import ru.turikhay.util.statistics.StatisticsSendingWrapper;

public class BrowserPanel
extends JFXPanel
implements LocalizableComponent,
Blockable {
    private static final long serialVersionUID = 5857121254870623943L;
    private static final boolean freeSurf = false;
    final BrowserHolder holder;
    final BrowserBridge bridge;
    private String failPage;
    private String style;
    private String scripts;
    private String background;
    private String currentDefaultPage;
    private int width;
    private int height;
    private boolean success;
    private boolean specialFlag = false;
    private Group group;
    private WebView view;
    private WebEngine engine;
    private long start = System.currentTimeMillis();
    private long startLater;
    public static String line = "";

    BrowserPanel(BrowserHolder h) throws IOException {
        this.holder = h;
        this.bridge = new BrowserBridge(this);
        this.loadResources();
        this.loadPageSync();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.startLater = System.currentTimeMillis();
                Thread.currentThread().setPriority(10);
                U.debug(Thread.currentThread().getName() + " has started a runLater " + (System.currentTimeMillis() - BrowserPanel.this.start) / 1000L + " seconds");
                BrowserPanel.log(new Object[]{"Running in JavaFX Thread"});
                BrowserPanel.this.prepareFX();
                BrowserPanel.this.initBrowser();
            }
        });
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BrowserPanel.this.width = BrowserPanel.this.holder.getWidth();
                BrowserPanel.this.height = BrowserPanel.this.holder.getHeight();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (BrowserPanel.this.view != null) {
                            BrowserPanel.this.view.setPrefSize((double)BrowserPanel.this.width, (double)BrowserPanel.this.height);
                        }
                    }
                });
            }
        });
    }

    private synchronized void loadResources() throws IOException {
        BrowserPanel.log("Loading resources...");
        URL failPageResource = this.getClass().getResource("fail.html");
        this.failPage = FileUtil.getTextResource(failPageResource);
        URL styleResource = this.getClass().getResource("style.css");
        this.style = FileUtil.getTextResource(styleResource);
        URL jqueryResource = this.getClass().getResource("jquery.js");
        URL pageScriptResource = this.getClass().getResource("scripts.js");
        this.scripts = FileUtil.getTextResource(jqueryResource) + '\n' + FileUtil.getTextResource(pageScriptResource);
        URL backgroundResource = ImageCache.getRes("plains.jpg");
        byte[] backgroundImageArray = FileUtil.readFully(backgroundResource.openStream());
        BrowserPanel.log("Loading background...");
        new Object();
        this.background = "page.background.setup('data:image/png;base64," + DatatypeConverter.printBase64Binary((byte[])backgroundImageArray) + "');";
        BrowserPanel.log("Cleaning up after loading:");
        U.gc();
    }

    synchronized void cleanupResources() {
        BrowserPanel.log("Cleaning up resources. Memory: " + U.getUsingSpace() + " / " + U.getTotalSpace() + " MB");
        this.style = null;
        this.scripts = null;
        this.background = null;
        U.gc();
    }

    private void prepareFX() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Call this method from Platform.runLater()");
        }
        BrowserPanel.log("Preparing JavaFX...");
        Thread.currentThread().setUncaughtExceptionHandler(ExceptionHandler.getInstance());
        this.group = new Group();
        Scene scene = new Scene((Parent)this.group);
        this.setScene(scene);
    }

    private synchronized void initBrowser() {
        String location;
        BrowserPanel.log("Initializing...");
        this.group.getChildren().removeAll((Object[])new Node[0]);
        this.view = JFXStartPageLoader.getInstance().getWebView();
        this.view.setContextMenuEnabled(false);
        this.view.setPrefSize((double)this.width, (double)this.height);
        final WebEngine currentEngine = this.engine = this.view.getEngine();
        this.engine.setOnAlert(new EventHandler(){

            public void handle(WebEvent<String> event) {
                Alert.showMessage(currentEngine.getTitle(), (String)event.getData());
            }

            public void handle(Event x0) {
                this.handle((WebEvent<String>)((WebEvent)x0));
            }
        });
        this.success = true;
        this.engine.getLoadWorker().stateProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                try {
                    BrowserPanel.this.onBrowserStateChanged(currentEngine, newValue);
                }
                catch (Throwable var5) {
                    BrowserPanel.engine(currentEngine, new Object[]{"State change handle error:", var5});
                }
            }

            public void changed(ObservableValue x0, Object x1, Object x2) {
                this.changed((ObservableValue<? extends Worker.State>)x0, (Worker.State)x1, (Worker.State)x2);
            }
        });
        if (this.engine.getLoadWorker().getState() == Worker.State.FAILED && !this.specialFlag) {
            location = this.engine.getLocation();
            this.failLoad(location);
        }
        if (this.engine.getLoadWorker().getState() == Worker.State.SUCCEEDED && !this.specialFlag) {
            location = this.engine.getLocation();
            this.loadSucceeded(location);
        }
        this.group.getChildren().add((Object)this.view);
    }

    private void failLoad(String location) {
        this.specialFlag = true;
        BrowserPanel.page(this.engine, "Failed to load", location);
        if (!this.success) {
            this.holder.setBrowserShown("error", false);
        } else {
            this.success = false;
            this.loadContent(this.failPage);
        }
    }

    private void onBrowserStateChanged(WebEngine engine, Worker.State val) {
        if (this.engine == engine) {
            if (val == null) {
                throw new NullPointerException("State is NULL!");
            }
            String location = engine.getLocation();
            this.view.setMouseTransparent(true);
            switch (SyntheticClass_1.$SwitchMap$javafx$concurrent$Worker$State[val.ordinal()]) {
                case 1: {
                    BrowserPanel.page(engine, "Loading", location);
                    if (location.isEmpty() || location.startsWith(TLauncher.getPageprefix())) break;
                    U.debug("[state] scheduled in");
                    URI uri = U.makeURI(location);
                    if (uri == null) {
                        uri = U.fixInvallidLink(location);
                    }
                    OS.openLink(uri);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String last = BrowserPanel.this.getLastEntry().getUrl();
                            BrowserPanel.page(BrowserPanel.this.engine, "Last entry", last);
                            BrowserPanel.this.loadPage(last);
                        }
                    });
                    break;
                }
                case 2: {
                    this.failLoad(location);
                }
                case 3: {
                    this.loadSucceeded(location);
                }
            }
        }
    }

    private void loadSucceeded(String location) {
        this.specialFlag = true;
        BrowserPanel.page(this.engine, "Loaded successfully", location);
        this.holder.setBrowserShown("error", true);
        this.success = true;
        Document document = this.engine.getDocument();
        NodeList bodies = document.getElementsByTagName("body");
        org.w3c.dom.Node body = bodies.item(0);
        if (body == null) {
            BrowserPanel.engine(this.engine, "What the...? Couldn't find <body> element!");
        } else {
            Element scriptElement;
            if (location.isEmpty()) {
                scriptElement = document.createElement("style");
                scriptElement.setAttribute("type", "text/css");
                scriptElement.setTextContent(this.style);
                body.appendChild(scriptElement);
            }
            scriptElement = document.createElement("script");
            scriptElement.setAttribute("type", "text/javascript");
            scriptElement.setTextContent(this.scripts);
            body.appendChild(scriptElement);
            this.engine.executeScript(this.background);
            JSObject jsobj = (JSObject)this.engine.executeScript("window");
            jsobj.setMember("bridge", this.bridge);
            NodeList linkList = document.getElementsByTagName("a");
            for (int adyoutube = 0; adyoutube < linkList.getLength(); ++adyoutube) {
                org.w3c.dom.Node serverInfoPage = linkList.item(adyoutube);
                EventTarget eventTarget = (EventTarget)((Object)serverInfoPage);
                eventTarget.addEventListener("click", new EventListener(){

                    @Override
                    public void handleEvent(org.w3c.dom.events.Event evt) {
                        EventTarget target = evt.getCurrentTarget();
                        HTMLAnchorElement anchorElement = (HTMLAnchorElement)((Object)target);
                        String href = anchorElement.getHref();
                        if (href != null && !href.isEmpty() && !href.startsWith("javascript:")) {
                            URI uri;
                            if (href.startsWith("http://zirijata.ru")) {
                                new StatisticsSendingWrapper(StatisticsCommand.ADVERTISING_CENTER, "center").startSending();
                            }
                            if ((uri = U.makeURI(href)) == null) {
                                uri = U.fixInvallidLink(href);
                            }
                            OS.openLink(uri);
                            evt.preventDefault();
                        }
                    }
                }, false);
            }
            Element var11 = document.getElementById("adyoutube");
            if (var11 != null) {
                ((EventTarget)((Object)var11)).addEventListener("click", new EventListener(){

                    @Override
                    public void handleEvent(org.w3c.dom.events.Event evt) {
                        new StatisticsSendingWrapper(StatisticsCommand.ADVERTISING_RIGHT_CORNER, "corner").startSending();
                    }
                }, false);
            }
            this.mixServers(document);
            this.addListensOnMenuServer(document);
            Element var12 = document.getElementById("server_info_page");
            if (var12 != null) {
                ((EventTarget)((Object)var12)).addEventListener("click", new EventListener(){

                    @Override
                    public void handleEvent(org.w3c.dom.events.Event evt) {
                        new Thread(ServerInfoPageController.getInstance()).start();
                    }
                }, false);
            }
            if (Blocker.isBlocked(this)) {
                this.block(null);
            }
            this.view.setMouseTransparent(false);
            U.debug(Thread.currentThread().getName() + " was ended after inited of runLater during " + (System.currentTimeMillis() - this.startLater) / 1000L + " seconds");
        }
    }

    private void removeChilds(org.w3c.dom.Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }

    private void mixServers(Document document) {
        Element element = document.getElementById("server_list");
        NodeList listRowServer = document.getElementsByTagName("server_row");
        ArrayList<org.w3c.dom.Node> listOld = new ArrayList<org.w3c.dom.Node>();
        for (int random = 0; random < listRowServer.getLength(); ++random) {
            org.w3c.dom.Node index = listRowServer.item(random);
            listOld.add(index);
        }
        if (element != null) {
            this.removeChilds(element);
            Random var7 = new Random();
            while (!listOld.isEmpty()) {
                int var8 = var7.nextInt(listOld.size());
                element.appendChild((org.w3c.dom.Node)listOld.remove(var8));
            }
        }
    }

    private void addListensOnMenuServer(Document doc) {
        BrowserPanel.log("add listens into server_choose");
        NodeList list = doc.getElementsByTagName("server");
        for (int i = 0; i < list.getLength(); ++i) {
            ((EventTarget)((Object)list.item(i))).addEventListener("mouseover", new EventListener(){

                @Override
                public void handleEvent(org.w3c.dom.events.Event evt) {
                    if (TLauncher.getInstance().getPopupMenuManager() != null) {
                        MouseEvent event = (MouseEvent)evt;
                        TLauncher.getInstance().getPopupMenuManager().processingEvent(BrowserPanel.this.extractServer(evt), event.getScreenY(), event.getScreenX());
                    }
                }
            }, false);
        }
    }

    private WebHistory.Entry getLastEntry() {
        WebHistory hist = this.engine.getHistory();
        return (WebHistory.Entry)hist.getEntries().get(hist.getCurrentIndex());
    }

    private String extractServer(org.w3c.dom.events.Event evt) {
        org.w3c.dom.Node idServer;
        NamedNodeMap map;
        org.w3c.dom.Node node = (org.w3c.dom.Node)((Object)evt.getCurrentTarget());
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null || nodeList.getLength() < 2) {
            BrowserPanel.log("nodeList=" + nodeList + " or nodeList.getLength() <2");
        }
        if ((map = nodeList.item(0).getAttributes()) == null || map.getLength() < 3) {
            BrowserPanel.log("map=" + map + "or map.getLength() <3");
        }
        if ((idServer = map.item(2)) != null) {
            if (idServer.getNodeValue() != null && !idServer.getNodeValue().isEmpty()) {
                if (evt instanceof MouseEvent) {
                    if (TLauncher.getInstance().getPopupMenuManager() == null) {
                        return null;
                    }
                    return idServer.getNodeValue();
                }
                BrowserPanel.log("problems with your browser");
            } else {
                BrowserPanel.log("idServer is null or empty");
            }
        } else {
            BrowserPanel.log("error the node doesn't have childNodes " + node.toString());
        }
        return null;
    }

    private void loadPage(String url) {
        U.debug("load started after init object = " + (System.currentTimeMillis() - this.start) / 1000L);
        BrowserPanel.engine(this.engine, "Trying to load URL: \"" + url + "\"");
        this.engine.load(url);
    }

    private void loadContent(String content) {
        this.engine.loadContent(content);
    }

    void execute(String script) {
        try {
            this.engine.executeScript(script);
        }
        catch (Exception var3) {
            U.log("Hidden JS exception:", var3);
        }
    }

    @Override
    public void block(Object reason) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.execute("page.visibility.hide();");
            }
        });
    }

    @Override
    public void unblock(Object reason) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BrowserPanel.this.execute("page.visibility.show();");
            }
        });
    }

    private static void log(Object ... o) {
        U.log("[Browser]", o);
    }

    private static void engine(WebEngine engine, Object ... o) {
        U.log("[Browser@" + engine.hashCode() + "]", o);
    }

    private static void page(WebEngine engine, String text, String page) {
        BrowserPanel.engine(engine, text + ':', '\"' + page + '\"');
    }

    @Override
    public void updateLocale() {
        Locale locale = TLauncher.getInstance().getSettings().getLocale();
        String oldDefaultPage = this.currentDefaultPage;
        this.currentDefaultPage = TLauncher.getPageprefix() + "index.html";
        if (oldDefaultPage != null && !oldDefaultPage.equals(this.currentDefaultPage)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    BrowserPanel.this.loadPage(BrowserPanel.this.currentDefaultPage);
                }
            });
        }
    }

    private void loadPageSync() {
        Locale locale = TLauncher.getInstance().getSettings().getLocale();
        String oldDefaultPage = this.currentDefaultPage;
        this.currentDefaultPage = TLauncher.getPageprefix() + "index.html";
        if (oldDefaultPage != null && !oldDefaultPage.equals(this.currentDefaultPage)) {
            this.loadPage(this.currentDefaultPage);
        }
    }

    static class SyntheticClass_1 {
        static final int[] $SwitchMap$javafx$concurrent$Worker$State = new int[Worker.State.values().length];

        SyntheticClass_1() {
        }

        static {
            try {
                SyntheticClass_1.$SwitchMap$javafx$concurrent$Worker$State[Worker.State.SCHEDULED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$javafx$concurrent$Worker$State[Worker.State.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SyntheticClass_1.$SwitchMap$javafx$concurrent$Worker$State[Worker.State.SUCCEEDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

