/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.updater;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.launcher.Http;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import ru.turikhay.tlauncher.managers.ServerList;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.U;

public class Stats {
    private static final ExecutorService service = Executors.newCachedThreadPool();
    private static boolean allow = false;

    public static boolean getAllowed() {
        return allow;
    }

    public static void setAllowed(boolean allowed) {
    }

    public static void minecraftLaunched(Account account, CompleteVersion version, ServerList.Server server) {
        Args args = Stats.newAction("mc_launched").add("mc_version", version.getID()).add("account_type", account.getType().toString());
        if (server != null) {
            args.add("launched_server", server.getAddress());
        }
        Stats.submitDenunciation(args);
    }

    private static Args newAction(String name) {
        return new Args(null).add("client", TLauncher.getInstance().getSettings().getClient().toString()).add("version", String.valueOf(TLauncher.getVersion())).add("action", name);
    }

    private static void submitDenunciation(Args args) {
        if (allow) {
            service.submit(new Callable(){

                public Void call() throws Exception {
                    return null;
                }
            });
        }
    }

    private static String toRequest(Args args) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry arg : args.map.entrySet()) {
            b.append('&').append(Http.encode((String)arg.getKey())).append('=').append(Http.encode((String)arg.getValue()));
        }
        return b.substring(1);
    }

    private static HttpURLConnection createUrlConnection(URL url) throws IOException {
        Validate.notNull(url);
        Stats.debug("Opening connection to " + url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(U.getProxy());
        connection.setConnectTimeout(U.getConnectionTimeout());
        connection.setReadTimeout(U.getReadTimeout());
        connection.setUseCaches(false);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String performGetRequest(URL url, String request) throws IOException {
        String var6;
        Validate.notNull(url);
        Validate.notNull(request);
        url = new URL(url.toString() + '?' + request);
        HttpURLConnection connection = Stats.createUrlConnection(url);
        Stats.debug("Reading data from " + url);
        InputStream inputStream = null;
        try {
            String result;
            inputStream = connection.getInputStream();
            String e = IOUtils.toString(inputStream, Charsets.UTF_8);
            Stats.debug("Successful read, server response was " + connection.getResponseCode());
            Stats.debug("Response: " + e);
            String string = result = e;
            return string;
        }
        catch (IOException var10) {
            IOUtils.closeQuietly(inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream == null) {
                Stats.debug("Request failed", var10);
                throw var10;
            }
            Stats.debug("Reading error page from " + url);
            String result = IOUtils.toString(inputStream, Charsets.UTF_8);
            Stats.debug("Successful read, server response was " + connection.getResponseCode());
            Stats.debug("Response: " + result);
            var6 = result;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return var6;
    }

    private static void debug(Object ... o) {
        U.log("[Stats]", o);
    }

    private static class Args {
        private final LinkedHashMap<String, String> map = new LinkedHashMap();

        private Args() {
        }

        public Args add(String key, String value) {
            if (this.map.containsKey(key)) {
                this.map.remove(key);
            }
            this.map.put(key, value);
            return this;
        }

        public Args remove(String key) {
            this.map.remove(key);
            return this;
        }

        Args(Object x0) {
            this();
        }
    }
}

