/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.util;

import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.rmo.Bootstrapper;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.util.Reflect;
import ru.turikhay.util.async.ExtendedThread;

public class U {
    public static final String PROGRAM_PACKAGE = "ru.turikhay";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    public static Logger logField;
    private static final int ST_TOTAL = 100;
    private static final int ST_PROGRAM = 10;
    private static String PREFIX;
    public static FileAppender fileAppender;
    private static final Object lock;

    public static void setPrefix(String prefix) {
        PREFIX = prefix;
    }

    public static String getPrefix() {
        return PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linelog(Object what) {
        Object var1 = lock;
        Object object = lock;
        synchronized (object) {
            System.out.print(what);
        }
    }

    public static void log(Object ... what) {
        U.hlog(PREFIX, what);
    }

    public static void plog(Object ... what) {
        U.hlog(null, what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hlog(String prefix, Object[] append) {
        Object var2 = lock;
        Object object = lock;
        synchronized (object) {
            String line = U.toLog(prefix, append);
            if (logField != null) {
                logField.info(line);
            }
            System.out.println(line);
        }
    }

    private static String toLog(String prefix, Object ... append) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (prefix != null) {
            b.append(prefix);
            first = false;
        }
        if (append != null) {
            Object[] arr$ = append;
            int len$ = append.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Object e = arr$[i$];
                if (e != null) {
                    if (e.getClass().isArray()) {
                        if (!first) {
                            b.append(" ");
                        }
                        if (e instanceof Object[]) {
                            b.append(U.toLog((Object[])e));
                            continue;
                        }
                        b.append(U.arrayToLog(e));
                        continue;
                    }
                    if (e instanceof Throwable) {
                        if (!first) {
                            b.append("\n");
                        }
                        b.append(U.stackTrace((Throwable)e));
                        b.append("\n");
                        continue;
                    }
                    if (e instanceof File) {
                        if (!first) {
                            b.append(" ");
                        }
                        File en = (File)e;
                        String absPath = en.getAbsolutePath();
                        b.append(absPath);
                        if (en.isDirectory() && !absPath.endsWith(File.separator)) {
                            b.append(File.separator);
                        }
                    } else if (e instanceof Iterator) {
                        Iterator var10 = (Iterator)e;
                        while (var10.hasNext()) {
                            b.append(" ");
                            b.append(U.toLog(var10.next()));
                        }
                    } else if (e instanceof Enumeration) {
                        Enumeration var11 = (Enumeration)e;
                        while (var11.hasMoreElements()) {
                            b.append(" ");
                            b.append(U.toLog(var11.nextElement()));
                        }
                    } else {
                        if (!first) {
                            b.append(" ");
                        }
                        b.append(e);
                    }
                } else {
                    if (!first) {
                        b.append(" ");
                    }
                    b.append("null");
                }
                if (!first) continue;
                first = false;
            }
        } else {
            b.append("null");
        }
        return b.toString();
    }

    public static String toLog(Object ... append) {
        return U.toLog(null, append);
    }

    private static String arrayToLog(Object e) {
        if (!e.getClass().isArray()) {
            throw new IllegalArgumentException("Given object is not an array!");
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if (e instanceof Object[]) {
            for (Object i : (Object[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(i);
            }
        } else if (e instanceof int[]) {
            for (int var16 : (int[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var16);
            }
        } else if (e instanceof boolean[]) {
            for (boolean var17 : (boolean[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var17);
            }
        } else if (e instanceof long[]) {
            for (long var18 : (long[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var18);
            }
        } else if (e instanceof float[]) {
            for (float var19 : (float[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var19);
            }
        } else if (e instanceof double[]) {
            for (double var20 : (double[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var20);
            }
        } else if (e instanceof byte[]) {
            for (byte var21 : (byte[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var21);
            }
        } else if (e instanceof short[]) {
            for (short var22 : (short[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var22);
            }
        } else if (e instanceof char[]) {
            for (char var23 : (char[])e) {
                if (!first) {
                    b.append(" ");
                } else {
                    first = false;
                }
                b.append(var23);
            }
        }
        if (b.length() == 0) {
            throw new UnknownError("Unknown array type given.");
        }
        return b.toString();
    }

    public static void setLoadingStep(Bootstrapper.LoadingStep step) {
        if (step == null) {
            throw new NullPointerException();
        }
        U.plog("[Loading]", step.toString());
    }

    public static short shortRandom() {
        return (short)new Random(System.currentTimeMillis()).nextInt(Short.MAX_VALUE);
    }

    public static double doubleRandom() {
        return new Random(System.currentTimeMillis()).nextDouble();
    }

    public static int random(int s, int e) {
        return new Random(System.currentTimeMillis()).nextInt(e - s) + s;
    }

    public static boolean ok(int d) {
        return new Random(System.currentTimeMillis()).nextInt(d) == 0;
    }

    public static double getAverage(double[] d) {
        double a = 0.0;
        int k = 0;
        double[] arr$ = d;
        int len$ = d.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double curd = arr$[i$];
            if (curd == 0.0) continue;
            a += curd;
            ++k;
        }
        if (k == 0) {
            return 0.0;
        }
        return a / (double)k;
    }

    public static double getAverage(double[] d, int max) {
        double a = 0.0;
        int k = 0;
        double[] arr$ = d;
        int len$ = d.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double curd = arr$[i$];
            a += curd;
            if (++k == max) break;
        }
        return k == 0 ? 0.0 : a / (double)k;
    }

    public static int getAverage(int[] d) {
        int a = 0;
        int k = 0;
        int[] arr$ = d;
        int len$ = d.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int curd = arr$[i$];
            if (curd == 0) continue;
            a += curd;
            ++k;
        }
        if (k == 0) {
            return 0;
        }
        return Math.round(a / k);
    }

    public static int getAverage(int[] d, int max) {
        int a = 0;
        int k = 0;
        int[] arr$ = d;
        int len$ = d.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int curd = arr$[i$];
            a += curd;
            if (++k == max) break;
        }
        return k == 0 ? 0 : Math.round(a / k);
    }

    public static int getSum(int[] d) {
        int a = 0;
        int[] arr$ = d;
        int len$ = d.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int curd = arr$[i$];
            a += curd;
        }
        return a;
    }

    public static double getSum(double[] d) {
        double a = 0.0;
        double[] arr$ = d;
        int len$ = d.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double curd = arr$[i$];
            a += curd;
        }
        return a;
    }

    public static int getMaxMultiply(int i, int max) {
        if (i <= max) {
            return 1;
        }
        for (int x = max; x > 1; --x) {
            if (i % x != 0) continue;
            return x;
        }
        return (int)Math.ceil(i / max);
    }

    @Deprecated
    public static String r(String string, int max) {
        if (string == null) {
            return null;
        }
        int len = string.length();
        if (len <= max) {
            return string;
        }
        String[] words = string.split(" ");
        String ret = "";
        int remaining = max + 1;
        for (int x = 0; x < words.length; ++x) {
            String curword = words[x];
            int curlen = curword.length();
            if (curlen >= remaining) {
                if (x != 0) break;
                ret = ret + " " + curword.substring(0, remaining - 1);
                break;
            }
            ret = ret + " " + curword;
            remaining -= curlen + 1;
        }
        return ret.length() == 0 ? "" : ret.substring(1) + "...";
    }

    public static String setFractional(double d, int fractional) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(fractional);
        return nf.format(d).replace(",", ".");
    }

    private static String stackTrace(Throwable e) {
        StringBuilder trace = U.rawStackTrace(e);
        ExtendedThread currentAsExtended = U.getAs(Thread.currentThread(), ExtendedThread.class);
        if (currentAsExtended != null) {
            trace.append("\nThread called by: ").append((CharSequence)U.rawStackTrace(currentAsExtended.getCaller()));
        }
        return trace.toString();
    }

    private static StringBuilder rawStackTrace(Throwable e) {
        Throwable var11;
        if (e == null) {
            return null;
        }
        StackTraceElement[] elems = e.getStackTrace();
        int programElements = 0;
        int totalElements = 0;
        StringBuilder builder = new StringBuilder();
        builder.append(e.toString());
        StackTraceElement[] cause = elems;
        int len$ = elems.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StackTraceElement elem = cause[i$];
            ++totalElements;
            String description = elem.toString();
            if (description.startsWith(PROGRAM_PACKAGE)) {
                ++programElements;
            }
            builder.append("\nat ").append(description);
            if (totalElements != 100 && programElements != 10) continue;
            int remain = elems.length - totalElements;
            if (remain == 0) break;
            builder.append("\n... and ").append(remain).append(" more");
            break;
        }
        if ((var11 = e.getCause()) != null) {
            builder.append("\nCaused by: ").append((CharSequence)U.rawStackTrace(var11));
        }
        return builder;
    }

    public static long getUsingSpace() {
        return U.getTotalSpace() - U.getFreeSpace();
    }

    public static long getFreeSpace() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public static long getTotalSpace() {
        return Runtime.getRuntime().totalMemory() / 0x100000L;
    }

    public static String memoryStatus() {
        return U.getUsingSpace() + " / " + U.getTotalSpace() + " MB";
    }

    public static void gc() {
        U.log("Starting garbage collector: " + U.memoryStatus());
        System.gc();
        U.log("Garbage collector completed: " + U.memoryStatus());
    }

    public static void sleepFor(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
    }

    public static URL makeURL(String p) {
        try {
            return new URL(p);
        }
        catch (Exception var2) {
            U.log("Cannot make URL from string: " + p + ".", var2);
            return null;
        }
    }

    public static URI makeURI(URL url) {
        try {
            return url.toURI();
        }
        catch (Exception var2) {
            U.log("Cannot make URI from URL: " + url + ".", var2);
            return null;
        }
    }

    public static URI makeURI(String p) {
        return U.makeURI(U.makeURL(p));
    }

    private static boolean interval(int min, int max, int num, boolean including) {
        return including ? num >= min && num <= max : num > max && num < max;
    }

    public static boolean interval(int min, int max, int num) {
        return U.interval(min, max, num, true);
    }

    public static int fitInterval(int val, int min, int max) {
        return val > max ? max : (val < min ? min : val);
    }

    public static long m() {
        return System.currentTimeMillis();
    }

    public static long n() {
        return System.nanoTime();
    }

    public static int getReadTimeout() {
        return U.getConnectionTimeout();
    }

    public static int getConnectionTimeout() {
        TLauncher t = TLauncher.getInstance();
        if (t == null) {
            return 15000;
        }
        Configuration.ConnectionQuality quality = t.getSettings().getConnectionQuality();
        return quality == null ? 15000 : quality.getTimeout();
    }

    public static Proxy getProxy() {
        return Proxy.NO_PROXY;
    }

    public static <T> T getRandom(T[] array) {
        return array == null ? null : (array.length == 0 ? null : (array.length == 1 ? array[0] : array[new Random().nextInt(array.length)]));
    }

    public static <K, E> LinkedHashMap<K, E> sortMap(Map<K, E> map, K[] sortedKeys) {
        if (map == null) {
            return null;
        }
        if (sortedKeys == null) {
            throw new NullPointerException("Keys cannot be NULL!");
        }
        LinkedHashMap<K, E> result = new LinkedHashMap<K, E>();
        K[] arr$ = sortedKeys;
        int len$ = sortedKeys.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            K key = arr$[i$];
            for (Map.Entry<K, E> entry : map.entrySet()) {
                K entryKey = entry.getKey();
                E value = entry.getValue();
                if (key == null && entryKey == null) {
                    result.put(null, value);
                    continue block0;
                }
                if (key == null || !key.equals(entryKey)) continue;
                result.put(key, value);
                continue block0;
            }
        }
        return result;
    }

    public static Color randomColor() {
        Random random = new Random();
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Color shiftColor(Color color, int bits) {
        if (color == null) {
            return null;
        }
        if (bits == 0) {
            return color;
        }
        int newRed = U.fitInterval(color.getRed() + bits, 0, 255);
        int newGreen = U.fitInterval(color.getGreen() + bits, 0, 255);
        int newBlue = U.fitInterval(color.getBlue() + bits, 0, 255);
        return new Color(newRed, newGreen, newBlue, color.getAlpha());
    }

    public static Color shiftAlpha(Color color, int bits) {
        if (color == null) {
            return null;
        }
        if (bits == 0) {
            return color;
        }
        int newAlpha = U.fitInterval(color.getAlpha() + bits, 0, 255);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), newAlpha);
    }

    @Deprecated
    public static <T> T getAs(Object o, Class<T> classOfT) {
        return Reflect.cast(o, classOfT);
    }

    public static boolean equal(Object a, Object b) {
        return a == b ? true : (a != null ? a.equals(b) : false);
    }

    public static String[] extend(String[] a0, String[] a1) {
        String[] newArray = new String[a0.length + a1.length];
        System.arraycopy(a0, 0, newArray, 0, a0.length);
        System.arraycopy(a1, 0, newArray, a0.length, a1.length);
        return newArray;
    }

    public static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Throwable var2) {
            var2.printStackTrace();
        }
    }

    public static <T> boolean is(T obj, T ... equal) {
        if (equal == null) {
            throw new NullPointerException("comparsion array");
        }
        if (obj == null) {
            T[] arr$ = equal;
            int len$ = equal.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                T compare = arr$[i$];
                if (compare != null) continue;
                return true;
            }
        } else {
            T[] arr$ = equal;
            int len$ = equal.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                T compare = arr$[i$];
                if (!obj.equals(compare)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> int find(T obj, T[] array) {
        if (obj == null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (!obj.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static void initializeLoggerU(String path, String type) {
        String separator = System.getProperty("file.separator");
        path = path + separator + "logs" + separator + "log4jFiles" + separator + type + "_data.log";
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName("RollingFileAppender");
        appender.setMaxBackupIndex(5);
        appender.setMaxFileSize("100kb");
        appender.setLayout(new PatternLayout("%d{ISO8601} %t %m%n"));
        appender.setFile(path);
        appender.setAppend(true);
        appender.setThreshold(Level.INFO);
        appender.activateOptions();
        Logger.getRootLogger().addAppender(appender);
        logField = Logger.getLogger("main");
    }

    public static void initAppendSwingUtil(String path) {
        FileAppender appender = new FileAppender();
        appender.setName("swing");
        appender.setFile(path);
        appender.setLayout(new PatternLayout("%t %m%n"));
        appender.setAppend(true);
        appender.setThreshold(Level.ALL);
        appender.activateOptions();
    }

    public static void debug(Object ... ob) {
        if (TLauncher.DEBUG) {
            U.plog("[DEBUG] ----- ", ob);
        }
    }

    public static URI makeURITest(String href) {
        try {
            return new URI(href);
        }
        catch (URISyntaxException var2) {
            var2.printStackTrace();
            return null;
        }
    }

    public static URI fixInvallidLink(String link) {
        try {
            if (link.contains("|")) {
                U.debug("U", "replace |");
                return new URI(link.replace("|", "%7C"));
            }
        }
        catch (Exception var3) {
            var3.printStackTrace();
        }
        try {
            if (link.contains("|")) {
                U.debug("U", "replace |");
                link = link.replace("|", "%7C");
            }
            if (link.indexOf("?") > -1) {
                return new URI(link.substring(0, link.indexOf("?")));
            }
        }
        catch (Exception var2) {
            var2.printStackTrace();
        }
        return null;
    }

    static {
        lock = new Object();
    }
}

