/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.listener;

import java.net.URI;
import ru.turikhay.tlauncher.configuration.Configuration;
import ru.turikhay.tlauncher.configuration.LangConfiguration;
import ru.turikhay.tlauncher.minecraft.crash.Crash;
import ru.turikhay.tlauncher.minecraft.crash.CrashSignatureContainer;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftException;
import ru.turikhay.tlauncher.minecraft.launcher.MinecraftListener;
import ru.turikhay.tlauncher.rmo.TLauncher;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public class MinecraftUIListener
implements MinecraftListener {
    private final TLauncher t;
    private final LangConfiguration lang;

    public MinecraftUIListener(TLauncher tlauncher) {
        this.t = tlauncher;
        this.lang = this.t.getLang();
    }

    @Override
    public void onMinecraftPrepare() {
    }

    @Override
    public void onMinecraftAbort() {
    }

    @Override
    public void onMinecraftLaunch() {
        if (!this.t.getSettings().getActionOnLaunch().equals((Object)Configuration.ActionOnLaunch.NOTHING)) {
            this.t.hide();
        }
    }

    @Override
    public void onMinecraftClose() {
        if (this.t.getLauncher().isLaunchAssist()) {
            this.t.show();
        }
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        if (!this.t.getLauncher().isLaunchAssist()) {
            this.t.show();
        }
        String p = "crash.";
        String title = Localizable.get(p + "title");
        String report = crash.getFile();
        if (!crash.isRecognized()) {
            Alert.showLocError(title, p + "unknown", null);
        } else {
            for (CrashSignatureContainer.CrashSignature sign : crash.getSignatures()) {
                String path = sign.getPath();
                String message = p + path;
                String url = p + "url";
                String urlPath = Localizable.get(url);
                URI uri = U.makeURI(urlPath);
                if (uri != null) {
                    if (!Alert.showLocQuestion(title, message, report)) continue;
                    OS.openLink(uri);
                    continue;
                }
                Alert.showLocMessage(title, message, report);
            }
        }
        if (report != null) {
            // empty if block
        }
    }

    @Override
    public void onMinecraftError(Throwable e) {
        Alert.showLocError("launcher.error.title", "launcher.error.unknown", e);
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Alert.showError(this.lang.get("launcher.error.title"), this.lang.get("launcher.error." + e.getLangPath(), e.getLangVars()), e.getCause());
    }
}

