/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.review;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import ru.turikhay.tlauncher.entity.Review;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.review.ReviewWindowListener;
import ru.turikhay.tlauncher.ui.review.ReviewWindowView;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.MinecraftUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.review.FolderEnum;
import ru.turikhay.util.review.ReferenceReview;

public class ReviewWindowController
implements ReviewWindowListener {
    private ReviewWindowView view;
    private JFrame frame;
    private List<File> list;
    private Thread referenceReview;

    public ReviewWindowController(JFrame frame) {
        this.frame = frame;
        this.view = new ReviewWindowView(frame, this);
        this.list = new ArrayList<File>();
    }

    public void setVisible(final boolean visible) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReviewWindowController.this.frame.setEnabled(!visible);
                ReviewWindowController.this.view.setVisible(visible);
            }
        });
    }

    public void addFileToSend(File file) {
        if (this.validate(file)) {
            this.list.add(file);
            this.view.addSendingFileView(file.getName());
        }
    }

    public void deleteFile(String actionCommand) {
        for (File file : this.list) {
            if (!file.getName().equals(actionCommand)) continue;
            this.list.remove(file);
            break;
        }
    }

    public void sendFilesToServer(Review review) {
        if (review.getTypeReview().equals(FolderEnum.BUG.getName()) || review.getTypeReview().equals(FolderEnum.COMPLAINT.getName()) || review.getTypeReview().equals(FolderEnum.LACK.getName())) {
            this.addLogToReview();
        }
        review.setListFiles(this.list);
        this.referenceReview = new Thread(new ReferenceReview(review, this));
        this.referenceReview.start();
    }

    public void cancelSending() {
        this.referenceReview.interrupt();
    }

    @Override
    public void eventFilesSend(final int result) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReviewWindowController.this.view.hideProgressBar();
                ReviewWindowController.this.setVisible(false);
                if (result == 0) {
                    Alert.showMessage("", Localizable.get().get("review.message.sendFile"));
                } else if (result == -1) {
                    Alert.showMonologError(Localizable.get().get("alert.error.send.log.unsuccess"), 0);
                }
            }
        });
    }

    private boolean validate(File file) {
        if (this.list.size() == 3) {
            Alert.showWarning(Localizable.get().get("review.chooser.warning.maxFile.title"), Localizable.get().get("review.chooser.warning.maxFile"));
            return false;
        }
        if (file.length() > 0x500000L) {
            Alert.showWarning(Localizable.get().get("review.chooser.warning.limitMaxSize.title"), Localizable.get().get("review.chooser.warning.limitMaxSize"));
            return false;
        }
        if (!ReviewWindowView.filter.accept(file)) {
            Alert.showWarning(Localizable.get().get("review.chooser.warning.limitMaxSize.title"), Localizable.get().get("review.chooser.warning.incorrectFile"));
            return false;
        }
        return true;
    }

    private void addLogToReview() {
        try {
            String e = FileUtil.archiveFile(new File(MinecraftUtil.getWorkingDirectory().getPath(), "/logs/log4jFiles").getCanonicalPath());
            this.list.add(new File(e));
        }
        catch (IOException var2) {
            U.log(var2);
        }
    }
}

