/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import ru.turikhay.tlauncher.minecraft.auth.Account;
import ru.turikhay.tlauncher.ui.images.ImageCache;
import ru.turikhay.tlauncher.ui.loc.Localizable;

public class AccountCellRenderer
implements ListCellRenderer<Account> {
    public static final Account EMPTY = Account.randomAccount();
    public static final Account MANAGE = Account.randomAccount();
    private static final Icon MANAGE_ICON = ImageCache.getIcon("gear.png");
    private static final Icon MOJANG_USER_ICON = ImageCache.getIcon("mojang-user.png");
    private static final Icon ELY_USER_ICON = ImageCache.getIcon("ely.png");
    private final DefaultListCellRenderer defaultRenderer;
    private AccountCellType type;

    public AccountCellRenderer(AccountCellType type) {
        if (type == null) {
            throw new NullPointerException("CellType cannot be NULL!");
        }
        this.defaultRenderer = new DefaultListCellRenderer();
        this.type = type;
    }

    public AccountCellRenderer() {
        this(AccountCellType.PREVIEW);
    }

    public AccountCellType getType() {
        return this.type;
    }

    public void setType(AccountCellType type) {
        if (type == null) {
            throw new NullPointerException("CellType cannot be NULL!");
        }
        this.type = type;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Account> list, Account value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        renderer.setAlignmentY(0.5f);
        if (value != null && !value.equals(EMPTY)) {
            if (value.equals(MANAGE)) {
                renderer.setText(Localizable.get("account.manage"));
                renderer.setIcon(MANAGE_ICON);
            } else {
                Icon icon = null;
                switch (value.getType()) {
                    case ELY: {
                        icon = ELY_USER_ICON;
                        break;
                    }
                    case MOJANG: {
                        icon = MOJANG_USER_ICON;
                    }
                }
                if (icon != null) {
                    renderer.setIcon(icon);
                    renderer.setFont(renderer.getFont().deriveFont(1));
                }
                switch (this.type) {
                    case EDITOR: {
                        if (!value.hasUsername()) {
                            renderer.setText(Localizable.get("account.creating"));
                            renderer.setFont(renderer.getFont().deriveFont(2));
                            break;
                        }
                        renderer.setText(value.getUsername());
                        break;
                    }
                    default: {
                        renderer.setText(value.getDisplayName());
                        break;
                    }
                }
            }
        } else {
            renderer.setText(Localizable.get("account.empty"));
        }
        return renderer;
    }

    public static enum AccountCellType {
        PREVIEW,
        EDITOR;

    }
}

