page = {
	maxWidth: 1060,
	maxHeight: 650,
    accessibility: {
        accessible: true,
        lock: function() {
            this.accessible = false;
            var body = $('body');

            $('#overlay').css('top', body.position().top).css('width', body.width()).css('height', body.height());
        },
        unlock: function() {
            this.accessible = true;
            $('#overlay').css('top', '0').css('width', '0').css('height', '0');
        }
    },
    visibility: {
        tick: 0,
        shown: true,
        show: function(then) {
            this.shown = true;

            page.accessibility.unlock();
            $('#page').stop().animate({opacity: 1}, this.tick, then);
        },
        hide: function(then) {
            this.shown = false;

            page.accessibility.lock();
            $('#page').stop().animate({opacity: 0}, this.tick, then);
        }
    },
    background: {
        tick: 1000,
        shown: false,
        show: function(then) {

            if(this.shown) {
                this.stylize(0);

                try { then(); }
                catch(e){}

                return;
            }

            this.shown = true;

            $('#background-overlay').stop().animate({opacity: 0}, this.tick, then);
        },
        hide: function(then) {

            if(!this.shown) {
                this.stylize(1);

                try { then(); }
                catch(e){}

                return;
            }

            this.shown = false;
            $('#background-overlay').stop().animate({opacity: 1}, this.tick, then);
        },
        setup: function(image) {
            this.hide(function() {

                var img =
                    $('<img />')
                        .attr('id', 'background-image')
                        .load(function() {
                        	page.background.show();
                        });

                $('#background-holder').html(img);
                $('#background-image').attr('src', image);

            });
        },
        stylize: function(opacity) {
            $('#background-overlay')
                .css('width', page.maxWidth)
                .css('height', page.maxHeight)
                .css('opacity', opacity);
        }
    }
};

$(document).ready(function() {
    window.pageReady = true;
});